/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.base.obj.KatelloUserRole;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli", "headpin-cli"})
public class UserTests
extends KatelloCliTestScript {
    List<KatelloUser> users;
    private String organization;
    private String env;

    @BeforeClass(description="init: create org stuff")
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.organization = "ak-" + uid;
        this.env = "ak-" + uid;
        KatelloOrg org = new KatelloOrg(this.organization, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env, null, this.organization, "Library");
        res = env.cli_create();
    }

    @Test(description="create user - for default org", enabled=true)
    public void test_create_DefaultOrg() {
        String uniqueID = KatelloUtils.getUniqueID();
        String username = "usr-" + uniqueID;
        String userpass = "password";
        String usermail = username + "@localhost";
        KatelloUser usr = new KatelloUser(username, usermail, userpass, false);
        SSHCommandResult res = usr.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user [ %s ]", username)), (String)"Check - returned output string (user create)");
        usr.asserts_create();
        if (this.users == null) {
            this.users = Collections.synchronizedList(new ArrayList());
        }
        this.users.add(usr);
    }

    @Test(description="create user - for default org (disabled)", enabled=true)
    public void test_createDisabled_DefaultOrg() {
        String uniqueID = KatelloUtils.getUniqueID();
        String username = "disabled-" + uniqueID;
        String userpass = "password";
        String usermail = username + "@localhost";
        KatelloUser usr = new KatelloUser(username, usermail, userpass, true);
        SSHCommandResult res = usr.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user [ %s ]", username)), (String)"Check - returned output string (user create)");
        usr.asserts_create();
    }

    @Test(description="List all users - admin should be there")
    public void test_listUsers_admin() {
        KatelloUser list_user = new KatelloUser(null, null, null, false);
        SSHCommandResult res = list_user.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("admin"), (String)"Check - contains: [admin]");
    }

    @Test(description="List users - created", dependsOnMethods={"test_create_DefaultOrg"})
    public void test_infoListUser() {
        KatelloUser list_user = this.createUser();
        this.users.add(list_user);
        SSHCommandResult res = list_user.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user list)");
        for (KatelloUser user : this.users) {
            String match_list = String.format(".*Id:\\s+\\d+.*Username:\\s+%s.*Email:\\s+%s.*", user.username, user.email).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_list), (String)("Check - user matches [" + user.username + "]"));
            this.assert_userInfo(user);
        }
    }

    @Test(description="delete users - for some org provided", enabled=true)
    public void test_DeleteUserOrg() {
        String uniqueID = KatelloUtils.getUniqueID();
        String username = "user-" + uniqueID;
        String userpass = "password";
        String usermail = username + "@localhost";
        KatelloUser usr = new KatelloUser(username, usermail, userpass, false, this.organization, this.env);
        SSHCommandResult res = usr.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user [ %s ]", username)), (String)"Check - returned output string (user create)");
        usr.asserts_create();
        res = usr.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted user [ %s ]", username)), (String)"Checked - returned output string (user delete)");
        usr.asserts_delete();
    }

    @Test(description="delete users - for default org ", enabled=true)
    public void test_DeleteUserDefaultOrg() {
        String uniqueID = KatelloUtils.getUniqueID();
        String username = "user-" + uniqueID;
        String userpass = "password";
        String usermail = username + "@localhost";
        KatelloUser usr = new KatelloUser(username, usermail, userpass, false);
        SSHCommandResult res = usr.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user [ %s ]", username)), (String)"Check - returned output string (user create)");
        usr.asserts_create();
        res = usr.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted user [ %s ]", username)), (String)"Checked - returned output string (user delete)");
        usr.asserts_delete();
    }

    @Test(description="Generates User Report - pdf format", enabled=true)
    public void test_UserReport_pdf() {
        String format = "pdf";
        SSHCommandResult res = KatelloUser.report(format);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user report)");
    }

    @Test(description="Generates User Report - html format", enabled=true)
    public void test_UserReport_html() {
        String format = "html";
        SSHCommandResult res = KatelloUser.report(format);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user report)");
    }

    @Test(description="Generates User Report - default format", enabled=true)
    public void test_UserReport() {
        String format = "";
        SSHCommandResult res = KatelloUser.report(format);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user report)");
    }

    @Test(description="Generates User Report - csv format", enabled=true)
    public void test_UserReport_csv() {
        String format = "csv";
        SSHCommandResult res = KatelloUser.report(format);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user report)");
    }

    @Test(description="assign roles to users", enabled=true)
    public void test_AssignUserRoles() {
        String uniqueID = KatelloUtils.getUniqueID();
        String username = "user-" + uniqueID;
        String userpass = "password";
        String usermail = username + "@localhost";
        String unique_role_ID = KatelloUtils.getUniqueID();
        String user_role_name = "user-role" + unique_role_ID;
        String role_desc = "Assigned " + user_role_name + " to user " + username;
        KatelloUser usr = new KatelloUser(username, usermail, userpass, false);
        SSHCommandResult res = usr.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user [ %s ]", username)), (String)"Check - returned output string (user create)");
        usr.asserts_create();
        KatelloUserRole usr_role = new KatelloUserRole(user_role_name, role_desc);
        res = usr_role.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user_role create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user role [ %s ]", user_role_name)), (String)"Check - returned output string (user_role create)");
        res = usr.assign_role(usr_role.name);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user assign_role)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("User '%s' assigned to role '%s'", username, user_role_name)), (String)"Check - returned output string (user assign_role)");
    }

    @Test(description="Create User and Role, assign role to user")
    public void test_assignRole() {
        KatelloUser user = this.createUser();
        KatelloUserRole role = this.createRole();
        SSHCommandResult res = user.assign_role(role.name);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user assign_role)");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("User '%s' assigned to role '%s'", user.username, role.name));
    }

    @Test(description="Create User and 2 Roles, assign roles to user and then unassign one of them. Verify that only one role is unassigned")
    public void test_unassignRole() {
        KatelloUser user = this.createUser();
        KatelloUserRole role = this.createRole();
        user.assign_role(role.name);
        KatelloUserRole role2 = this.createRole();
        user.assign_role(role2.name);
        SSHCommandResult res = user.unassign_role(role.name);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user unassign_role)");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("User '%s' unassigned from role '%s'", user.username, role.name));
        res = user.list_roles();
        String out = this.getOutput(res).replaceAll("\n", "");
        String match_list = String.format(".*\\d+\\s+%s.*", role2.name).replaceAll("\"", "");
        Assert.assertTrue((boolean)out.matches(match_list), (String)("Check - user role matches [" + role2.name + "]"));
    }

    @Test(description="Create User and Roles, assign roles to user, verify list_roles shows them")
    public void test_listRoles() {
        KatelloUser user = this.createUser();
        KatelloUserRole role = this.createRole();
        user.assign_role(role.name);
        KatelloUserRole role1 = this.createRole();
        user.assign_role(role1.name);
        KatelloUserRole role2 = this.createRole();
        user.assign_role(role2.name);
        KatelloUserRole role3 = this.createRole();
        user.assign_role(role3.name);
        SSHCommandResult res = user.list_roles();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user list_roles)");
        String out = this.getOutput(res).replaceAll("\n", "");
        String match_list = String.format(".*\\d+\\s+%s.*", role.name).replaceAll("\"", "");
        Assert.assertTrue((boolean)out.matches(match_list), (String)("Check - user role matches [" + role.name + "]"));
        match_list = String.format(".*\\d+\\s+%s.*", role.name).replaceAll("\"", "");
        Assert.assertTrue((boolean)out.matches(match_list), (String)("Check - user role matches [" + role1.name + "]"));
        match_list = String.format(".*\\d+\\s+%s.*", role.name).replaceAll("\"", "");
        Assert.assertTrue((boolean)out.matches(match_list), (String)("Check - user role matches [" + role2.name + "]"));
        match_list = String.format(".*\\d+\\s+%s.*", role.name).replaceAll("\"", "");
        Assert.assertTrue((boolean)out.matches(match_list), (String)("Check - user role matches [" + role3.name + "]"));
    }

    @Test(description="Delete a user", enabled=true)
    public void test_deleteUser() {
        KatelloUser user = this.createUser();
        SSHCommandResult res = user.delete();
        Assert.assertEquals((int)res.getExitCode(), (int)0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted user [ %s ]", user.username)), (String)"Check - return string");
        res = user.cli_info();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code [65]");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)String.format("Could not find user [ %s ]", user.username));
    }

    private void assert_userInfo(KatelloUser user) {
        SSHCommandResult res = user.cli_info();
        String match_info = String.format(".*Id:\\s+\\d+.*Username:\\s+%s.*Email:\\s+%s.*", user.username, user.email).replaceAll("\"", "");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("User (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("User [%s] should be found in the result info", user.username));
    }

    private KatelloUser createUser() {
        String uniqueID = KatelloUtils.getUniqueID();
        String username = "usr-" + uniqueID;
        String userpass = "password";
        String usermail = username + "@localhost";
        KatelloUser user = new KatelloUser(username, usermail, userpass, false);
        user.cli_create();
        return user;
    }

    private KatelloUserRole createRole() {
        String uniqueID = KatelloUtils.getUniqueID();
        String rolename = "role-" + uniqueID;
        String descr = "role-desc";
        KatelloUserRole role = new KatelloUserRole(rolename, descr);
        role.create();
        return role;
    }
}

