/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloGpgKey;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class GpgKeyExtTests
extends KatelloCliTestScript {
    private String rand;
    private String org;
    private String gpg;
    private String filename;

    @BeforeClass(description="init: create org, prepare gpg file on disk")
    public void setUp() {
        this.rand = KatelloUtils.getUniqueID();
        this.org = "gpgExt-" + this.rand;
        this.filename = "/tmp/RPM-GPG-KEY-dummy-packages-generator";
        this.gpg = "key-" + this.rand;
        KatelloOrg org = new KatelloOrg(this.org, "Org for GPG extended cli tests");
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (org create)");
        String cmd = "rm -f " + this.filename + "; " + "curl -sk " + "http://inecas.fedorapeople.org/fakerepos/zoo/RPM-GPG-KEY-dummy-packages-generator" + " -o " + this.filename;
        res = KatelloUtils.sshOnClient(cmd);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (get gpg file)");
        KatelloGpgKey gpg = new KatelloGpgKey(this.gpg, this.org, this.filename);
        res = gpg.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (gpg_key create)");
    }

    @Test(description="creating product by giving non-existing gpgkey")
    public void test_createProduct_wrongGpgkey() {
        String rand = KatelloUtils.getUniqueID();
        KatelloProvider prov = new KatelloProvider("gpgext-" + rand, this.org, null, null);
        prov.create();
        String gpgNotExist = "gpg-" + rand;
        KatelloProduct prod = new KatelloProduct("prod-" + rand, this.org, prov.name, null, gpgNotExist, null, null, null);
        SSHCommandResult res = prod.create();
        Assert.assertTrue((res.getExitCode() == 244 ? 1 : 0) != 0, (String)"Check return code (product create with wrong gpgkey name)");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Couldn't find GpgKey with name = %s", gpgNotExist)), (String)"Check - error string");
    }

    @Test(description="create product specifying gpgkey")
    public void test_createProduct_validGpg() {
        String _prov = "gpgProv1-" + this.rand;
        KatelloProvider prov = new KatelloProvider(_prov, this.org, null, null);
        prov.create();
    }
}

