/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloTemplate;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class ChangesetTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(ChangesetTests.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String env_name;
    private String chst_name;
    private String provider_name;
    private String product_name;
    private String repo_name;
    private String templ_name;

    @BeforeClass(description="init: create org stuff", groups={"cli-changeset"})
    public void setUp() {
        String uid = KatelloUtils.getUniqueID();
        this.org_name = "org" + uid;
        this.env_name = "env" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        this.repo_name = "repo" + uid;
        this.templ_name = "template" + KatelloUtils.getUniqueID();
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", "http://inecas.fedorapeople.org/fakerepos/zoo3/");
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (env create)");
        KatelloTemplate tpl = new KatelloTemplate(this.templ_name, null, this.org_name, null);
        this.exec_result = tpl.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Successfully created template [ %s ]", this.templ_name)), (String)"Check - output string (template create)");
    }

    @Test(description="Create changeset", groups={"cli-changeset"})
    public void test_createChangeset() {
        KatelloChangeset chst = this.createChangeset();
        this.assert_changesetInfo(chst);
    }

    @Test(description="Create changeset be existing name", groups={"cli-changeset"})
    public void test_createChangesetExists() {
        KatelloChangeset chst = this.createChangeset();
        this.exec_result = chst.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Validation failed: Name Must be unique within an environment");
    }

    @Test(description="Create 2 changesets, delete one of them", groups={"cli-changeset"})
    public void test_deleteChangeset() {
        KatelloChangeset chst = this.createChangeset();
        KatelloChangeset chst2 = this.createChangeset();
        String chstId = this.assert_changesetInfo(chst);
        this.assert_changesetInfo(chst2);
        this.exec_result = chst.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset delete)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Deleted changeset '%s'", chstId)), (String)"Check - output string (changeset delete)");
        this.assert_changesetList(Arrays.asList(chst2), Arrays.asList(chst));
        this.exec_result = chst.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (changeset delete)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Could not find changeset [ %s ] within environment [ %s ]", chst.name, chst.environment)), (String)"Check - output string (changeset not exists)");
    }

    @Test(description="Create changeset and then list it", groups={"cli-changeset"})
    public void test_listChangeset() {
        KatelloChangeset chst = this.createChangeset();
        String chst_name2 = "changeset" + KatelloUtils.getUniqueID();
        KatelloChangeset cs = new KatelloChangeset(chst_name2, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        this.assert_changesetList(Arrays.asList(chst, cs), new ArrayList<KatelloChangeset>());
    }

    @Test(description="Create changeset and then promote it", groups={"cli-changeset"})
    public void test_promoteChangeset() {
        KatelloChangeset chst = this.createChangeset();
        this.assert_changesetInfo(chst);
        this.exec_result = chst.apply();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        chst.state = "promoted";
        this.assert_changesetInfo(chst);
    }

    @Test(description="Create changeset, than update changeset name", groups={"cli-changeset"})
    public void test_updateChangesetName() {
        KatelloChangeset chst = this.createChangeset();
        String oldName = chst.name;
        String newName = chst.name + "new";
        this.exec_result = chst.update_name(newName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        chst.name = newName;
        this.assert_changesetInfo(chst);
        chst.name = oldName;
        this.exec_result = chst.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Could not find changeset [ %s ] within environment [ %s ]", chst.name, chst.environment));
    }

    @Test(description="Create changeset, than add product to changeset", groups={"cli-changeset"})
    public void test_updateChangesetAddProduct() {
        KatelloChangeset chst = this.createChangeset();
        this.exec_result = chst.update_addProduct(this.product_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated changeset [ %s ]", this.chst_name)), (String)"Check - output string (changeset update)");
        this.exec_result = chst.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Products:\\s+.*%s.*", this.product_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Product should exist in changeset info");
    }

    @Test(description="Create changeset, add product to changeset and then remove product", groups={"cli-changeset"})
    public void test_updateChangesetRemoveProduct() {
        KatelloChangeset chst = this.createChangeset();
        this.exec_result = chst.update_addProduct(this.product_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = chst.update_removeProduct(this.product_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated changeset [ %s ]", this.chst_name)), (String)"Check - output string (changeset update)");
        this.exec_result = chst.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Products:\\s+.*%s.*", this.product_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertFalse((boolean)matcher.find(), (String)"Check - Product should not exist in changeset info");
    }

    @Test(description="Create changeset, than add repo to changeset", groups={"cli-changeset"})
    public void test_updateChangesetAddRepo() {
        KatelloChangeset chst = this.createChangeset();
        this.exec_result = chst.update_fromProduct_addRepo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated changeset [ %s ]", this.chst_name)), (String)"Check - output string (changeset update)");
        this.exec_result = chst.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Repositories:\\s+.*%s.*", this.repo_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Repository should exist in changeset info");
    }

    @Test(description="Create changeset, add repo to changeset, then delete it", groups={"cli-changeset"})
    public void test_updateChangesetRemoveRepo() {
        KatelloChangeset chst = this.createChangeset();
        this.exec_result = chst.update_fromProduct_addRepo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = chst.update_fromProduct_removeRepo(this.product_name, this.repo_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated changeset [ %s ]", this.chst_name)), (String)"Check - output string (changeset update)");
        this.exec_result = chst.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Repositories:\\s+.*%s.*", this.repo_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertFalse((boolean)matcher.find(), (String)"Check - Repository should not exist in changeset info");
    }

    @Test(description="Create changeset, than add template to changeset", groups={"cli-changeset"})
    public void test_updateChangesetAddTemplate() {
        KatelloChangeset chst = this.createChangeset();
        this.exec_result = chst.update_addTemplate(this.templ_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated changeset [ %s ]", this.chst_name)), (String)"Check - output string (changeset update)");
        this.exec_result = chst.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*System Templates:\\s+.*%s.*", this.templ_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Template should exist in changeset info");
    }

    @Test(description="Create changeset, add template to changeset, then remove template", groups={"cli-changeset"})
    public void test_updateChangesetRemoveTemplate() {
        KatelloChangeset chst = this.createChangeset();
        this.exec_result = chst.update_addTemplate(this.templ_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = chst.update_removeTemplate(this.templ_name);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains(String.format("Successfully updated changeset [ %s ]", this.chst_name)), (String)"Check - output string (changeset update)");
        this.exec_result = chst.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*System Templates:\\s+.*%s.*", this.templ_name).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertFalse((boolean)matcher.find(), (String)"Check - Template should not exist in changeset info");
    }

    private KatelloChangeset createChangeset() {
        this.chst_name = "changeset" + KatelloUtils.getUniqueID();
        KatelloChangeset cs = new KatelloChangeset(this.chst_name, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset create)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Successfully created changeset [ %s ] for environment [ %s ]", this.chst_name, this.env_name)), (String)"Check - output string (changeset create)");
        return cs;
    }

    private String assert_changesetInfo(KatelloChangeset chst) {
        if (chst.description == null) {
            chst.description = "None";
        }
        if (chst.state == null) {
            chst.state = "new";
        }
        this.exec_result = chst.info();
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*State:\\s+%s.*Environment Name:\\s+%s.*", chst.name, chst.description, chst.state, chst.environment).replaceAll("\"", "");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Changeset (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Changeset [%s] should be found in the result info", chst.name));
        Pattern pattern = Pattern.compile("Id:\\s+\\d+\\s+Name:");
        Matcher matcher = pattern.matcher(this.getOutput(this.exec_result).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Id should exist in changeset info");
        String id = matcher.group();
        id = id.replace("Id:", "").replace("Name:", "").trim();
        return id;
    }

    private void assert_changesetList(List<KatelloChangeset> chsts, List<KatelloChangeset> excludeChsts) {
        String match_info;
        this.exec_result = new KatelloChangeset(this.chst_name, this.org_name, this.env_name).list();
        for (KatelloChangeset chst : chsts) {
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*\\s+%s.*", chst.name, chst.environment).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Changeset [%s] should be found in the result list", chst.name));
        }
        for (KatelloChangeset chst : excludeChsts) {
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*\\s+%s.*", chst.name, chst.environment).replaceAll("\"", "");
            Assert.assertFalse((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Changeset [%s] should be found in the result list", chst.name));
        }
    }
}

