/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloApiException;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.Test;

@Test(groups={"cfse-api"})
public class UsersTest
extends KatelloTestScript {
    protected static Logger log = Logger.getLogger(UsersTest.class.getName());
    private String username_disabled;
    private String username_enabled;
    private Long userid_disabled;

    @Test(groups={"testUsers"}, description="Create user (disabled)")
    public void test_createUserDisabled() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        String pid = KatelloUtils.getUniqueID();
        this.username_disabled = "user_" + pid;
        KatelloUser user = null;
        try {
            user = this.servertasks.createUser(this.username_disabled, "root@localhost", "testing", true);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create user", (Throwable)e);
        }
        Assert.assertNotNull((Object)user.getId(), (String)"Check: not null returned: id");
        boolean disabled = user.isDisabled();
        Assert.assertTrue((boolean)disabled, (String)"Check: returned value: disabled=true");
        this.userid_disabled = user.getId();
        log.info("Preparing disabled user: [" + this.username_disabled + "]");
    }

    @Test(groups={"testUsers"}, description="Create user (enabled)")
    public void test_createUserEnabled() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        String pid = KatelloUtils.getUniqueID();
        this.username_enabled = "user_" + pid;
        KatelloUser user = null;
        try {
            user = this.servertasks.createUser(this.username_enabled, "root@localhost", "testing", false);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create user", (Throwable)e);
        }
        Assert.assertNotNull((Object)user.getId(), (String)"Check: not null returned: id");
        boolean disabled = user.isDisabled();
        Assert.assertFalse((boolean)disabled, (String)"Check: returned value: disabled=false");
        log.info("Preparing enabled user: [" + this.username_enabled + "]");
    }

    @Test(dependsOnMethods={"test_createUserDisabled", "test_createUserEnabled"}, groups={"testUsers"}, description="Get all users")
    public void test_getUsers() {
        List<KatelloUser> users = null;
        try {
            users = this.servertasks.listUsers();
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get user list", (Throwable)e);
        }
        boolean containsAdmin = false;
        boolean userFound_D = false;
        boolean userFound_E = false;
        for (KatelloUser user : users) {
            if (user.getUsername().equals("admin")) {
                containsAdmin = true;
            }
            if (user.getUsername().equals(this.username_enabled)) {
                userFound_E = true;
                Assert.assertFalse((boolean)user.isDisabled(), (String)"Check: enabled user's disabled flag.");
            }
            if (!user.getUsername().equals(this.username_disabled)) continue;
            userFound_D = true;
            Assert.assertTrue((boolean)user.isDisabled(), (String)"Check: disabled user's disabled flag.");
        }
        Assert.assertTrue((userFound_D && userFound_E && containsAdmin ? 1 : 0) != 0, (String)("Check: all users (admin, " + this.username_disabled + ", " + this.username_enabled + ") should be found in the list"));
    }

    @Test(dependsOnMethods={"test_createUserDisabled", "test_createUserEnabled"}, groups={"testUsers"}, description="Get user")
    public void test_getUser() {
        KatelloUser user = null;
        try {
            user = this.servertasks.getUser(this.userid_disabled);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not get user", (Throwable)e);
        }
        Assert.assertTrue((boolean)user.getUsername().contains(this.username_disabled), (String)"Check: returned username");
        Assert.assertTrue((boolean)user.isDisabled(), (String)"Check: returned username's disabled status");
    }

    @Test(groups={"testUsers"}, description="Update user properties")
    public void test_updateUser() {
        String pid = KatelloUtils.getUniqueID();
        String updUser = "updUser_" + pid;
        KatelloUser user = null;
        try {
            user = this.servertasks.createUser(updUser, "root@localhost", "testing", false);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create user", (Throwable)e);
        }
        Long userId = user.getId();
        String pwdHash = user.getPassword();
        try {
            this.servertasks.updateUser(userId, "disabled", Boolean.TRUE);
            KatelloUser updatedUser = this.servertasks.getUser(userId);
            Assert.assertTrue((boolean)updatedUser.isDisabled(), (String)"Check: updated disable status");
            this.servertasks.updateUser(userId, "password", "123456");
            updatedUser = this.servertasks.getUser(userId);
            Assert.assertFalse((boolean)updatedUser.getPassword().contains(pwdHash), (String)"Check: updated password");
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Error while updating user", (Throwable)e);
        }
    }

    @Test(groups={"testUsers"}, description="Delete user")
    public void test_deleteUser() {
        String pid = KatelloUtils.getUniqueID();
        String updUser = "delUser_" + pid;
        KatelloUser user = null;
        try {
            user = this.servertasks.createUser(updUser, "root@localhost", "testing", false);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not create user", (Throwable)e);
        }
        Long userId = user.getId();
        String _ret = null;
        try {
            _ret = this.servertasks.deleteUser(userId);
        }
        catch (KatelloApiException e) {
            Assert.fail((String)"Could not delete user", (Throwable)e);
        }
        Assert.assertEquals((String)_ret, (String)String.format("Deleted user '%s'", userId.toString()), (String)"Check: returned message of delete command");
        KatelloUser throwAway = null;
        try {
            throwAway = this.servertasks.getUser(userId);
        }
        catch (KatelloApiException e) {
            Assert.assertNull((Object)throwAway, (String)"Check: returned error message - getUsers()");
        }
    }
}

