/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.upgrade.v1;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloGpgKey;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.Test;

public class ScenCustomRepo
implements KatelloConstants {
    protected static Logger log = Logger.getLogger(ScenCustomRepo.class.getName());
    String _uid = KatelloTestScript.getUniqueID();
    String _org;
    String _provider;
    String _product;
    String _repo;
    String _env;
    String _changeset;
    String _system;
    String _gpg_key;

    @Test(description="init object unique names", groups={"pre-upgrade"})
    public void init() {
        this._org = "upgV1-" + this._uid;
        this._provider = "Zoo " + this._uid;
        this._product = "Zoo " + this._uid;
        this._repo = "zoo3-" + this._uid;
        this._env = "env-" + this._uid;
        this._changeset = "chs-" + this._uid;
        this._system = "localhost-" + this._uid;
        this._gpg_key = "gpg_zoo-" + this._uid;
    }

    @Test(description="prepare and sync the repo", dependsOnMethods={"init"}, groups={"pre-upgrade"})
    public void createAndSyncRepo() {
        KatelloUtils.sshOnClient("yum -y erase wolf lion || true");
        KatelloUtils.sshOnClient("subscription-manager unsubscribe --all");
        KatelloUtils.sshOnClient("subscription-manager unregister");
        KatelloUtils.sshOnClient("subscription-manager clean");
        KatelloUtils.sshOnClient("rpm -e gpg-pubkey-f78fb195-4f0d5ba1 || true");
        KatelloOrg org = new KatelloOrg(this._org, null);
        KatelloUtils.sshOnClient("wget http://inecas.fedorapeople.org/fakerepos/zoo/RPM-GPG-KEY-dummy-packages-generator -O /tmp/RPM-GPG-KEY-dummy-packages-generator");
        KatelloGpgKey gpg_key = new KatelloGpgKey(this._gpg_key, this._org, "/tmp/RPM-GPG-KEY-dummy-packages-generator");
        KatelloProvider provider = new KatelloProvider(this._provider, this._org, null, null);
        KatelloProduct product = new KatelloProduct(this._product, this._org, this._provider, null, null, null, null, null);
        KatelloRepo repo = new KatelloRepo(this._repo, this._org, this._product, "http://inecas.fedorapeople.org/fakerepos/zoo3/", this._gpg_key, null);
        KatelloEnvironment env = new KatelloEnvironment(this._env, null, this._org, "Library");
        KatelloChangeset cs = new KatelloChangeset(this._changeset, this._org, this._env);
        org.cli_create();
        gpg_key.cli_create();
        provider.create();
        product.create();
        env.cli_create();
        repo.create();
        repo.synchronize();
        cs.create();
        cs.update_addProduct(this._product);
        cs.promote();
        KatelloSystem sys = new KatelloSystem(this._system, this._org, this._env);
        sys.rhsm_registerForce();
        String pool = KatelloTasks.grepCLIOutput("PoolId", sys.subscriptions_available().getStdout().trim(), 1);
        sys.rhsm_subscribe(pool);
        KatelloUtils.sshOnClient("service goferd restart;");
    }

    @Test(description="verify org survived the upgrade", dependsOnGroups={"pre-upgrade", "upgrade"}, groups={"post-upgrade"})
    public void checkOrgSurvived() {
        KatelloOrg org = new KatelloOrg(this._org, null);
        SSHCommandResult res = org.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (org info)");
    }

    @Test(description="verify repo survived the upgrade", dependsOnGroups={"pre-upgrade", "upgrade"}, groups={"post-upgrade"})
    public void checkRepoSurvived() {
        KatelloRepo repo = new KatelloRepo(this._repo, this._org, this._product, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        SSHCommandResult res = repo.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (org info)");
    }

    @Test(description="verify after the upgrade package can be installed on system", dependsOnGroups={"pre-upgrade", "upgrade"}, dependsOnMethods={"checkRepoSurvived"}, groups={"post-upgrade"})
    public void checkPackageInstalls() {
        KatelloUtils.sshOnClient("yum clean all");
        KatelloUtils.sshOnClient("yum repolist");
        KatelloUtils.sshOnClient("rpm --import /tmp/RPM-GPG-KEY-dummy-packages-generator");
        KatelloSystem sys = new KatelloSystem(this._system, this._org, null);
        SSHCommandResult res = sys.packages_install("lion");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (remote install lion)");
        Assert.assertTrue((boolean)res.getStdout().trim().contains("Remote action finished:"), (String)"Check - output string (remote action finished)");
        Assert.assertTrue((boolean)res.getStdout().trim().contains("lion-"), (String)"Check - output string (contains package name installed)");
        res = KatelloUtils.sshOnClient("rpm -q lion");
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (rpm -q lion)");
    }
}

