/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPermission;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloSystem;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.base.obj.KatelloUserRole;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class RhsmOnlyPermissions
extends KatelloCliTestScript {
    private static Logger log = Logger.getLogger(RhsmOnlyPermissions.class.getName());
    String org;
    private String env_dev;
    private String env_test;
    private String user;
    private String user_role;
    private String system;
    private String prod;
    private String repo;

    @BeforeClass(description="Init org/env", alwaysRun=true)
    public void setUp() {
        String uid = KatelloTestScript.getUniqueID();
        this.env_dev = "Dev-" + uid;
        this.env_test = "Test-" + uid;
        this.user = "usr" + uid;
        this.user_role = "Full RHSM " + uid;
        this.system = "systemof-" + this.user;
        this.org = "org-RHSM-only-" + uid;
        KatelloOrg org = new KatelloOrg(this.org, null);
        org.cli_create();
        KatelloEnvironment env = new KatelloEnvironment(this.env_dev, null, this.org, "Library");
        env.cli_create();
        env = new KatelloEnvironment(this.env_test, null, this.org, "Library");
        env.cli_create();
    }

    @Test(description="Create user & user_role", enabled=true)
    public void test_createUserAndRole() {
        log.info("Preparing: user, user_role");
        KatelloUser user = new KatelloUser(this.user, "root@localhost", "testing", false);
        user.cli_create();
        user.asserts_create();
        KatelloUserRole role = new KatelloUserRole(this.user_role, "Full RHSM access for an env. scope");
        SSHCommandResult res = role.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user_role create)");
    }

    @Test(description="Create permission and assign to user", dependsOnMethods={"test_createUserAndRole"}, enabled=true)
    public void test_permissionAssign() {
        log.info("Create RHSM full access permission and assign it to the user.");
        KatelloPermission perm = new KatelloPermission(this.user_role, this.org, "environments", this.env_dev, "update_systems,read_contents,read_systems,register_systems,delete_systems", this.user_role);
        perm.create();
        KatelloUser user = new KatelloUser(this.user, null, null, false);
        SSHCommandResult res = user.assign_role(this.user_role);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user assign_role)");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("User '%s' assigned to role '%s'", this.user, this.user_role)), (String)"Check - return code (user assign_role)");
    }

    @Test(description="Register user", dependsOnMethods={"test_permissionAssign"}, enabled=true)
    public void test_rhsmRegisterSystem() {
        log.info("Register the system");
        this.rhsm_clean();
        String cmd = String.format("subscription-manager register --username %s --password %s --org \"%s\" --environment \"%s\" --name \"%s\"", this.user, "testing", this.org, this.env_dev, this.system);
        SSHCommandResult res = KatelloUtils.sshOnClient(cmd);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (rhsm register)");
        Assert.assertTrue((boolean)this.getOutput(res).contains("The system has been registered"), (String)"Check - message (registered)");
    }

    @Test(description="Sync Zoo3 repo", dependsOnMethods={"test_rhsmRegisterSystem"}, enabled=true)
    public void test_syncZoo3() {
        String uid = KatelloTestScript.getUniqueID();
        String providerName = "Zoo3_" + uid;
        this.prod = "Zoo 3 - " + uid;
        this.repo = "Zoo3-" + uid;
        log.info("Sync and promote Zoo3 to the dev env. Subscribe the system to it.");
        KatelloProvider prov = new KatelloProvider(providerName, this.org, null, null);
        prov.create();
        KatelloProduct prod = new KatelloProduct(this.prod, this.org, providerName, null, null, null, null, null);
        prod.create();
        KatelloRepo repo = new KatelloRepo(this.repo, this.org, this.prod, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        repo.create();
        repo.synchronize();
        KatelloChangeset cs1 = new KatelloChangeset("cs" + uid, this.org, this.env_dev);
        cs1.create();
        cs1.update_addProduct(this.prod);
        SSHCommandResult res = cs1.apply();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset promote)");
    }

    @Test(description="Subscribe system to Zoo3", dependsOnMethods={"test_syncZoo3"}, enabled=true)
    public void test_subscribeSystemToZoo3() {
        String cmd;
        String poolName;
        log.info("Subscribing system to the pool of: Zoo3");
        KatelloSystem sys = new KatelloSystem(this.system, this.org, null);
        SSHCommandResult res = sys.subscriptions_available();
        String pool = KatelloTasks.grepCLIOutput("PoolId", this.getOutput(res).trim(), 1);
        if (pool == null) {
            pool = KatelloTasks.grepCLIOutput("Pool Id", this.getOutput(res).trim(), 1);
        }
        if ((poolName = KatelloTasks.grepCLIOutput("PoolName", this.getOutput(res).trim(), 1)) == null) {
            poolName = KatelloTasks.grepCLIOutput("PoolName", this.getOutput(res).trim(), 1);
        }
        Assert.assertTrue(((res = KatelloUtils.sshOnClient(cmd = "subscription-manager subscribe --pool " + pool)).getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (rhsm subscribe)");
        String MATCH_SUBSCRIBED = "Successfully.*" + poolName + ".*";
        Assert.assertTrue((boolean)this.getOutput(res).matches(MATCH_SUBSCRIBED), (String)"Check - message (subscribed)");
    }

    @Test(description="Yum operations", dependsOnMethods={"test_subscribeSystemToZoo3"}, enabled=true)
    public void test_yumOperations() {
        log.info("Checks on: yum repolist, packages count");
        SSHCommandResult res = KatelloUtils.sshOnClient("yum repolist | grep \"" + this.repo + "\"");
        Assert.assertFalse((boolean)this.getOutput(res).equals(""), (String)"Yum repolist contains the repo just subscribed");
        String sRev = new StringBuffer(this.getOutput(res).trim()).reverse().toString();
        String pkgCountRev = sRev.substring(0, sRev.indexOf(" ") + 1);
        int pkgFromYum = Integer.parseInt(new StringBuffer(pkgCountRev).reverse().toString().trim());
        KatelloRepo repo = new KatelloRepo(this.repo, this.org, this.prod, null, null, null);
        res = repo.info(this.env_dev);
        int pkgFromKatello = Integer.parseInt(KatelloTasks.grepCLIOutput("Package Count", this.getOutput(res).trim()));
        Assert.assertTrue((pkgFromYum == pkgFromKatello ? 1 : 0) != 0, (String)"Check: package counts for both yum and katello repo");
    }
}

