/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPackageGroup;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class PackageGroupTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(PackageGroupTests.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String user_name;
    private String provider_name;
    private String product_name;
    private String repo_name;
    private String repo_id;
    private String env_name;
    private String changeset_name;

    @BeforeClass(description="Generate unique objects")
    public void setUp() {
        String uid = KatelloTestScript.getUniqueID();
        this.org_name = "org" + uid;
        this.user_name = "user" + uid;
        this.provider_name = "provider" + uid;
        this.product_name = "product" + uid;
        this.repo_name = "repo" + uid;
        this.env_name = "env" + uid;
        this.changeset_name = "changeset" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUser user = new KatelloUser(this.user_name, "root@localhost", "testing", false);
        this.exec_result = user.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", null);
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloChangeset cs = new KatelloChangeset(this.changeset_name, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        prov.synchronize();
        cs.apply();
    }

    @Test(description="packagegroup list", groups={"cli-packagegroup"}, enabled=true)
    public void test_packageGroupList() {
        KatelloRepo repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = repo.info();
        this.repo_id = KatelloTasks.grepCLIOutput("Id", this.getOutput(this.exec_result).trim(), 1);
        KatelloPackageGroup packGr = new KatelloPackageGroup(null, null, null);
        this.exec_result = packGr.cli_list(this.repo_id);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("mammals"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("birds"));
        packGr.id = "birds";
        packGr.name = "birds";
        this.assert_packageGroupInfo(packGr, this.repo_id);
        packGr.id = "mammals";
        packGr.name = "mammals";
        this.assert_packageGroupInfo(packGr, this.repo_id);
    }

    private void assert_packageGroupInfo(KatelloPackageGroup pack, String repoId) {
        SSHCommandResult res = pack.cli_info(repoId);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(pack.id), (String)"Check - package group Id should exist in list result");
        Assert.assertTrue((boolean)this.getOutput(res).contains(pack.name), (String)"Check - package group name should exist in list result");
    }
}

