/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloErrata;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class PromoteErrata
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(PromoteErrata.class.getName());
    public static final String ERRATA_ZOO_SEA = "RHEA-2012:0002";
    private String org;
    private String env = "Dev";
    private String provider;
    private String product;
    private String repo;
    private String cs1;
    private String cs2;

    @BeforeClass(description="Init unique names", alwaysRun=true)
    public void setUp() {
        String uniqueID = KatelloTestScript.getUniqueID();
        this.org = "Zoo Corporation " + uniqueID;
        this.provider = "ZooProv" + uniqueID;
        this.product = "ZooProd" + uniqueID;
        this.repo = "ZooRepo" + uniqueID;
        this.cs1 = "ZooDev1" + uniqueID;
        this.cs2 = "ZooDev2" + uniqueID;
        log.info("E2E - Create org");
        KatelloOrg org = new KatelloOrg(this.org, null);
        org.cli_create();
    }

    @Test(description="Create org, provider, product and repo", enabled=true)
    public void test_prepareRepo() {
        log.info("E2E - Create provider/product/repo");
        KatelloProvider prov = new KatelloProvider(this.provider, this.org, null, null);
        prov.create();
        KatelloProduct prod = new KatelloProduct(this.product, this.org, this.provider, null, null, null, null, null);
        prod.create();
        KatelloRepo repo = new KatelloRepo(this.repo, this.org, this.product, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        repo.create();
    }

    @Test(description="Create environment", enabled=true)
    public void test_prepareEnv() {
        log.info("E2E - Create environment");
        KatelloEnvironment env = new KatelloEnvironment(this.env, null, this.org, "Library");
        env.cli_create();
    }

    @Test(description="Promote empty product/repo structure to Dev", dependsOnMethods={"test_prepareRepo", "test_prepareEnv"}, enabled=true)
    public void test_promoteToDevNoSync() {
        log.info("E2E - Promote to Dev - not synced");
        KatelloChangeset cs = new KatelloChangeset(this.cs1, this.org, this.env);
        cs.create();
        cs.update_addProduct(this.product);
        cs.apply();
    }

    @Test(description="Synchronize repository", dependsOnMethods={"test_promoteToDevNoSync"}, enabled=true)
    public void test_syncRepo() {
        log.info("E2E - Synchronize repo");
        KatelloRepo repo = new KatelloRepo(this.repo, this.org, this.product, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        repo.synchronize();
    }

    @Test(description="Add errata and promote 2nd time", dependsOnMethods={"test_syncRepo"}, enabled=true)
    public void test_addErrataAndPromote() {
        log.info("E2E - Add errata (only) and promote again");
        KatelloChangeset cs = new KatelloChangeset(this.cs2, this.org, this.env);
        cs.create();
        SSHCommandResult res = cs.update_fromProduct_addErrata(this.product, ERRATA_ZOO_SEA);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset --add_erratum)");
        res = cs.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(".*Errata:\\s+.*%s.*", ERRATA_ZOO_SEA).replaceAll("\"", "");
        Pattern pattern = Pattern.compile(match_info);
        Matcher matcher = pattern.matcher(this.getOutput(res).replaceAll("\n", " "));
        Assert.assertTrue((boolean)matcher.find(), (String)"Check - Errata should exist in changeset info");
        res = cs.apply();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset promote)");
        KatelloErrata ert = new KatelloErrata(ERRATA_ZOO_SEA, this.org, this.product, this.repo, this.env);
        res = ert.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (errata info --environment Dev)");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").contains(ERRATA_ZOO_SEA), (String)"Check - errata info output");
    }
}

