/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliDataProvider;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloUserRole;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class UserRoleTests
extends KatelloCliTestScript {
    @Test(description="create User Role", groups={"headpin-cli"}, dataProvider="user_role_create", dataProviderClass=KatelloCliDataProvider.class, enabled=true)
    public void testUserRole_create(String name, String descr, Integer exitCode, String output) {
        KatelloUserRole user_role = new KatelloUserRole(name, descr);
        SSHCommandResult res = user_role.create();
        Assert.assertTrue((res.getExitCode().intValue() == exitCode.intValue() ? 1 : 0) != 0, (String)"Check - return code");
        if (exitCode == 0) {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned output string");
        } else {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned error string");
        }
    }

    @Test(description="User Role Update", groups={"headpin-cli"})
    public void testUserRole_update() {
        String uid = KatelloTestScript.getUniqueID();
        String name = "role-" + uid;
        String descr = "Test user role created";
        String new_name = "role-newname" + uid;
        KatelloUserRole user_role = new KatelloUserRole(name, descr);
        SSHCommandResult res = user_role.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user role [ %s ]", name)), (String)"Check - returned output string (user_role create)");
        res = user_role.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = user_role.cli_update(new_name);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully updated user role [ %s ]", name)), (String)"Check - returned output string (user_role update)");
    }

    @Test(description="delete a UserRole", groups={"headpin-cli"}, enabled=true)
    public void test_delete_UserRole() {
        String uid = KatelloTestScript.getUniqueID();
        String user_role_name = "user_role-delete-" + uid;
        KatelloUserRole user_role = new KatelloUserRole(user_role_name, "User Role Created");
        SSHCommandResult res = user_role.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user role [ %s ]", user_role_name)), (String)"Check - returned output string (user_role create)");
        res = user_role.cli_delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully deleted user role [ %s ]", user_role_name)), (String)"Check - returned output string (user_role delete)");
        res = user_role.cli_info();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (user role delete)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Cannot find user role [ %s ]", user_role_name)), (String)"Check - returned output string (user_role info -v)");
        res = user_role.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role list)");
    }

    @Test(description="Add ldap group to a UserRole", groups={"headpin-cli", "openldap"}, enabled=true)
    public void test_add_ldap_group() {
        String uid = KatelloTestScript.getUniqueID();
        String user_role_name = "user_role-ldap_grp-" + uid;
        String ldap_group = "group-" + uid;
        KatelloUserRole user_role = new KatelloUserRole(user_role_name, "User Role Created");
        SSHCommandResult res = user_role.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user role [ %s ]", user_role_name)), (String)"Check - returned output string (user_role create)");
        res = user_role.cli_add_ldap_group(ldap_group);
        int exitCode = res.getExitCode();
        if (exitCode == 244) {
            throw new SkipException("Skip");
        }
        if (exitCode == 0) {
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role add ldap group)");
            Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully added LDAP group [ %s ] to the user role [ %s ]", ldap_group, user_role_name)), (String)"Check - returned output string (user_role add_ldap_group)");
            res = user_role.cli_info();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role info)");
        }
    }

    @Test(description="Remove ldap group to a UserRole", groups={"headpin-cli", "openldap"}, enabled=true)
    public void test_remove_ldap_group() {
        String uid = KatelloTestScript.getUniqueID();
        String user_role_name = "user_role-ldap_grp-" + uid;
        String ldap_group = "group-" + uid;
        KatelloUserRole user_role = new KatelloUserRole(user_role_name, "User Role Created");
        SSHCommandResult res = user_role.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role create)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully created user role [ %s ]", user_role_name)), (String)"Check - returned output string (user_role create)");
        res = user_role.cli_add_ldap_group(ldap_group);
        int exitCode = res.getExitCode();
        if (exitCode == 244) {
            throw new SkipException("Skip");
        }
        if (exitCode == 0) {
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role add ldap group)");
            Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully added LDAP group [ %s ] to the user role [ %s ]", ldap_group, user_role_name)), (String)"Check - returned output string (user_role add_ldap_group)");
            res = user_role.cli_info();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role info)");
            res = user_role.cli_remove_ldap_group(ldap_group);
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role remove ldap group)");
            Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully removed LDAP group [ %s ] from the user role [ %s ]", ldap_group, user_role_name)), (String)"Check - returned output string (user_role remove_ldap_group)");
            res = user_role.cli_info();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (user role info)");
        }
    }
}

