/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloSyncPlan;
import com.redhat.qe.katello.tests.cli.PackageTests;
import com.redhat.qe.tools.SSHCommandResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class SyncPlanTests
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(PackageTests.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String syncplan_name;

    @BeforeClass(description="Generate unique objects")
    public void setUp() {
        String uid = KatelloTestScript.getUniqueID();
        this.org_name = "org" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="Create sync plan", groups={"cli-sync_plan"})
    public void test_createSyncPlan() {
        KatelloSyncPlan sp = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.hourly);
        this.assert_syncplanInfo(sp);
        this.assert_syncplanList(Arrays.asList(sp), new ArrayList<KatelloSyncPlan>());
    }

    @Test(description="Create sync plan which name exists", groups={"cli-sync_plan"})
    public void test_createSyncPlanExists() {
        KatelloSyncPlan sp = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.hourly);
        this.exec_result = sp.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code (sync plan create)");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Validation failed: Name has already been taken");
    }

    @Test(description="Create sync plan which date is wrong", groups={"cli-sync_plan"})
    public void test_createSyncPlanWrongDate() {
        String uid = KatelloTestScript.getUniqueID();
        this.syncplan_name = "splan" + uid;
        SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");
        KatelloSyncPlan sp = new KatelloSyncPlan(this.syncplan_name, this.org_name, null, "2012-11", tformat.format(new Date()), KatelloSyncPlan.SyncPlanInterval.hourly);
        this.exec_result = sp.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Date format is invalid. Required: YYYY-MM-DD");
    }

    @Test(description="Create sync plan which time is wrong", groups={"cli-sync_plan"})
    public void test_createSyncPlanWrongTime() {
        String uid = KatelloTestScript.getUniqueID();
        this.syncplan_name = "splan" + uid;
        SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd");
        KatelloSyncPlan sp = new KatelloSyncPlan(this.syncplan_name, this.org_name, null, dformat.format(new Date()), "11:77:88", KatelloSyncPlan.SyncPlanInterval.hourly);
        this.exec_result = sp.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)"Time format is invalid. Required: HH:MM:SS[+HH:MM]");
    }

    @Test(description="Create sync plan update it's name", groups={"cli-sync_plan"})
    public void test_updateSyncPlanName() {
        KatelloSyncPlan sp = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.hourly);
        String oldName = sp.name;
        String newName = sp.name + "new";
        this.exec_result = sp.update_name(newName);
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        sp.name = newName;
        sp.interval = KatelloSyncPlan.SyncPlanInterval.none.toString();
        this.assert_syncplanInfo(sp);
        sp.name = oldName;
        this.exec_result = sp.info();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(this.exec_result).trim(), (String)String.format("Cannot find sync plan [ %s ]", sp.name));
    }

    @Test(description="Create sync plan update it's date", groups={"cli-sync_plan"})
    public void test_updateSyncPlanDate() {
        KatelloSyncPlan sp = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.hourly);
        SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.add(2, 1);
        this.exec_result = sp.update_date(dformat.format(cal.getTime()), tformat.format(cal.getTime()));
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        sp.date = dformat.format(cal.getTime());
        sp.time = tformat.format(cal.getTime());
        sp.interval = KatelloSyncPlan.SyncPlanInterval.none.toString();
        this.assert_syncplanInfo(sp);
    }

    @Test(description="Create 2 sync plans, delete one of them", groups={"cli-sync_plan"})
    public void test_deleteSyncplan() {
        KatelloSyncPlan sp = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.hourly);
        KatelloSyncPlan sp2 = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.daily);
        this.exec_result = sp.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (changeset delete)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Successfully deleted sync plan [ %s ]", sp.name)), (String)"Check - output string (sync plan delete)");
        this.assert_syncplanList(Arrays.asList(sp2), Arrays.asList(sp));
        this.exec_result = sp.delete();
        Assert.assertTrue((this.exec_result.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code (sync plan delete)");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).equals(String.format("Cannot find sync plan [ %s ]", sp.name)), (String)"Check - output string (sync plan not exists)");
    }

    private KatelloSyncPlan createSyncPlan(Date date, KatelloSyncPlan.SyncPlanInterval interval) {
        String uid = KatelloTestScript.getUniqueID();
        this.syncplan_name = "splan" + uid;
        SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");
        KatelloSyncPlan sp = new KatelloSyncPlan(this.syncplan_name, this.org_name, null, dformat.format(date), tformat.format(date), interval);
        this.exec_result = sp.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        return sp;
    }

    private void assert_syncplanList(List<KatelloSyncPlan> splans, List<KatelloSyncPlan> excludeSplans) {
        String match_info;
        this.exec_result = new KatelloSyncPlan(null, this.org_name, null, null, null, null).list();
        for (KatelloSyncPlan sp : splans) {
            if (sp.description == null) {
                sp.description = "None";
            }
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*\\s+%s.*\\s+%s.*\\s+%s.*", sp.name, sp.description, sp.date.replaceAll("-", "/") + " " + sp.time, sp.interval).replaceAll("\"", "");
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Sync Plan [%s] should be found in the result list", sp.name));
        }
        for (KatelloSyncPlan sp : excludeSplans) {
            if (sp.description == null) {
                sp.description = "None";
            }
            match_info = String.format(".*\\s+\\d+.*\\s+%s.*\\s+%s.*\\s+%s.*\\s+%s.*", sp.name, sp.description, sp.date.replaceAll("-", "/") + " " + sp.time, sp.interval).replaceAll("\"", "");
            Assert.assertFalse((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Sync Plan [%s] should be found in the result list", sp.name));
        }
    }

    private void assert_syncplanInfo(KatelloSyncPlan sp) {
        if (sp.description == null) {
            sp.description = "None";
        }
        this.exec_result = sp.info();
        String match_info = String.format(".*Id:\\s+\\d+.*Name:\\s+%s.*Description:\\s+%s.*Start date:\\s+%s.*Interval:\\s+%s.*", sp.name, sp.description, sp.date.replaceAll("-", "/") + " " + sp.time, sp.interval).replaceAll("\"", "");
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        log.finest(String.format("Sync Plan (info) match regex: [%s]", match_info));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).replaceAll("\n", " ").matches(match_info), (String)String.format("Sync Plan [%s] should be found in the result info", sp.name));
    }
}

