/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloTemplate;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloActivationKey {
    String org;
    String environment;
    String name;
    String description;
    String template;
    String limit;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;
    private String id;
    private String environment_id;
    private String template_id;
    public static final String CMD_CREATE = "activation_key create";
    public static final String CMD_INFO = "activation_key info";
    public static final String CMD_LIST = "activation_key list";
    public static final String CMD_DELETE = "activation_key delete";
    public static final String CMD_UPDATE = "activation_key update";
    public static final String CMD_ADD_SYSTEMGROUP = "activation_key add_system_group";
    public static final String CMD_REMOVE_SYSTEMGROUP = "activation_key remove_system_group";
    public static final String ERR_TEMPLATE_NOTFOUND = "Could not find template [ %s ]";
    public static final String OUT_CREATE = "Successfully created activation key [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted activation key [ %s ]";
    public static final String OUT_ADD_SYSTEMGROUP = "Successfully added system group to activation key [ %s ]";
    public static final String OUT_REMOVE_SYSTEMGROUP = "Successfully removed system group from activation key [ %s ]";
    public static final String ERROR_INFO = "Could not find activation key [ %s ]";
    public static final String ERROR_EXCEED = "Usage limit (%s) exhausted for activation key '%s'";

    public KatelloActivationKey(String pOrg, String pEnv, String pName, String pDesc, String pTemplate) {
        this(pOrg, pEnv, pName, pDesc, pTemplate, null);
    }

    public KatelloActivationKey(String pOrg, String pEnv, String pName, String pDesc, String pTemplate, String pLimit) {
        this.org = pOrg;
        this.environment = pEnv;
        this.name = pName;
        this.description = pDesc;
        this.template = pTemplate;
        this.limit = pLimit;
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", this.environment));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("template", this.template));
        this.opts.add(new Attribute("limit", this.limit));
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli("activation_key list -v", this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list(String pEnvironment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", pEnvironment));
        this.cli = new KatelloCli("activation_key list -v", this.opts);
        return this.cli.run();
    }

    public SSHCommandResult extend_limit(String newlimit) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("limit", newlimit));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult add_system_group(String pSystemGroup) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_group", pSystemGroup));
        this.cli = new KatelloCli(CMD_ADD_SYSTEMGROUP, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult remove_system_group(String pSystemGroup) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("system_group", pSystemGroup));
        this.cli = new KatelloCli(CMD_REMOVE_SYSTEMGROUP, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli("activation_key delete -v", this.opts);
        return this.cli.run();
    }

    public void asserts_create() {
        SSHCommandResult res;
        if (this.id == null) {
            this.updateIDs();
        }
        Assert.assertTrue(((res = this.list(this.environment)).getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key list)");
        String REGEXP_AK_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Environment Id:\\s+%s.*System Template Id:\\s+%s.*";
        String match_info = String.format(REGEXP_AK_LIST, this.name, this.environment_id, this.template_id).replaceAll("\"", "");
        if (this.template_id == null) {
            match_info = String.format(REGEXP_AK_LIST, this.name, this.environment_id, "None").replaceAll("\"", "");
        }
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Activation key [%s] should be found in the list", this.name));
        res = this.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key info)");
        String REGEXP_AK_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Usage Limit:\\s+%s.*Environment Id:\\s+%s.*System Template Id:\\s+%s.*Pools:.*";
        match_info = String.format(REGEXP_AK_INFO, this.name, this.limit != null ? this.limit : "unlimited", this.environment_id, this.template_id).replaceAll("\"", "");
        if (this.template_id == null) {
            match_info = String.format(REGEXP_AK_INFO, this.name, this.limit != null ? this.limit : "unlimited", this.environment_id, "None").replaceAll("\"", "");
        }
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Activation key [%s] should contain correct info", this.name));
    }

    private void updateIDs() {
        SSHCommandResult res;
        if (this.environment != null) {
            KatelloEnvironment env = new KatelloEnvironment(this.environment, null, this.org, "Library");
            res = env.cli_info();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment info)");
            this.environment_id = KatelloTasks.grepCLIOutput("Id", res.getStdout());
        }
        if (this.template != null) {
            KatelloTemplate tmpl = new KatelloTemplate(this.template, null, this.org, null);
            res = tmpl.info(this.environment);
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (template info)");
            this.template_id = KatelloTasks.grepCLIOutput("Id", res.getStdout());
        }
        if (this.name != null) {
            res = this.info();
            this.id = KatelloTasks.grepCLIOutput("Id", res.getStdout());
        }
    }
}

