/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.redhat.qe.katello.base.KatelloApi;
import com.redhat.qe.katello.base.KatelloPostParam;
import com.redhat.qe.katello.base.KatelloTestScript;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.testng.annotations.Test;

public class DemoKatelloApi {
    @Test(description="demo KatelloApi.get")
    public void test_apiGet() {
        KatelloApi.get("/organizations");
    }

    @Test(description="demo KatelloApi.post - simple")
    public void test_apiPost_simple() {
        ArrayList<NameValuePair> opts = new ArrayList<NameValuePair>();
        String rand = KatelloTestScript.getUniqueID();
        opts.add((NameValuePair)new BasicNameValuePair("name", "demoApi-" + rand));
        opts.add((NameValuePair)new BasicNameValuePair("description", "simple description - here it can be null as well"));
        KatelloPostParam[] params = new KatelloPostParam[]{new KatelloPostParam(null, opts)};
        KatelloApi.post(params, "/organizations");
    }

    @Test(description="demo KatelloApi.post - more complex")
    public void test_apiPost_complex() {
        ArrayList<NameValuePair> opts = new ArrayList<NameValuePair>();
        String rand = KatelloTestScript.getUniqueID();
        opts.add((NameValuePair)new BasicNameValuePair("name", "demoApi-env-" + rand));
        opts.add((NameValuePair)new BasicNameValuePair("description", null));
        opts.add((NameValuePair)new BasicNameValuePair("prior", "1"));
        KatelloPostParam[] params = new KatelloPostParam[]{new KatelloPostParam("environment", opts)};
        KatelloApi.post(params, String.format("/organizations/%s/environments", "ACME_Corporation"));
    }
}

