/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.upgrade.v1;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.Test;

public class ScenCustomRepo
implements KatelloConstants {
    protected static Logger log = Logger.getLogger(ScenCustomRepo.class.getName());
    String _uid = KatelloTestScript.getUniqueID();
    String _org;
    String _provider;
    String _product;
    String _repo;

    @Test(description="init object unique names", groups={"pre-upgrade"})
    public void init() {
        this._org = "upgV1-" + this._uid;
        this._provider = "Zoo " + this._uid;
        this._product = "Zoo " + this._uid;
        this._repo = "zoo3-" + this._uid;
    }

    @Test(description="prepare and sync the repo", dependsOnMethods={"init"}, groups={"pre-upgrade"})
    public void createAndSyncRepo() {
        KatelloOrg org = new KatelloOrg(this._org, null);
        KatelloProvider provider = new KatelloProvider(this._provider, this._org, null, null);
        KatelloProduct product = new KatelloProduct(this._product, this._org, this._provider, null, null, null, null, null);
        KatelloRepo repo = new KatelloRepo(this._repo, this._org, this._product, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        org.cli_create();
        provider.create();
        product.create();
        repo.create();
        repo.synchronize();
    }

    @Test(description="verify org survived the upgrade", dependsOnGroups={"pre-upgrade", "upgrade"}, groups={"post-upgrade"})
    public void checkOrgSurvived() {
        KatelloOrg org = new KatelloOrg(this._org, null);
        SSHCommandResult res = org.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - exit code (org info)");
    }
}

