/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.e2e;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloChangeset;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloPackage;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.base.obj.KatelloSyncPlan;
import com.redhat.qe.katello.base.obj.KatelloUser;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import org.testng.annotations.Test;

@Test(groups={"cfse-e2e"})
public class RepoSyncByPlan
extends KatelloCliTestScript {
    protected static Logger log = Logger.getLogger(RepoSyncByPlan.class.getName());
    private SSHCommandResult exec_result;
    private String org_name;
    private String user_name;
    private String provider_name;
    private String product_name;
    private String repo_name;
    private String env_name;
    private String changeset_name;
    private String repo_path;
    private String repo_url;
    private String uid;
    private KatelloProduct prod;
    private KatelloRepo repo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="sync never synced repo by syncplan")
    public void test_syncNotSyncedRepo() {
        this.createZooReport();
        KatelloSyncPlan sp = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.hourly);
        KatelloPackage pack = new KatelloPackage(null, null, this.org_name, this.product_name, this.repo_name, null);
        this.prod.cli_set_plan(sp.name);
        SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.add(12, 59);
        this.exec_result = this.repo.info();
        String lastSync = KatelloTasks.grepCLIOutput("Last Sync", this.getOutput(this.exec_result).trim(), 1);
        Assert.assertEquals((String)lastSync, (String)"never", (String)"Repo is synced, but should not");
        try {
            KatelloUtils.sshOnServer("date -s " + tformat.format(new Date(cal.getTimeInMillis())));
            this.waitfor_reposync(this.repo, lastSync, 3);
            this.exec_result = pack.cli_list();
            Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("lion"));
        }
        finally {
            cal = Calendar.getInstance();
            cal.add(12, -59);
            KatelloUtils.sshOnServer("date -s " + tformat.format(new Date(cal.getTimeInMillis())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="sync local repo by sync plan when packages are added in repo")
    public void test_syncLocalRepo() {
        this.createLocalReport();
        KatelloSyncPlan sp = this.createSyncPlan(new Date(), KatelloSyncPlan.SyncPlanInterval.hourly);
        KatelloPackage pack = new KatelloPackage(null, null, this.org_name, this.product_name, this.repo_name, null);
        this.prod.cli_set_plan(sp.name);
        SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.add(12, 59);
        this.exec_result = this.repo.info();
        String lastSync = KatelloTasks.grepCLIOutput("Last Sync", this.getOutput(this.exec_result).trim(), 1);
        this.exec_result = pack.cli_list();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("wolf"));
        Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("walrus"));
        Assert.assertFalse((boolean)this.getOutput(this.exec_result).contains("lion"));
        this.updateLocalRepo();
        try {
            KatelloUtils.sshOnServer("date -s " + tformat.format(new Date(cal.getTimeInMillis())));
            this.waitfor_reposync(this.repo, lastSync, 3);
            this.exec_result = pack.cli_list();
            Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("wolf"));
            Assert.assertFalse((boolean)this.getOutput(this.exec_result).contains("walrus"));
            Assert.assertTrue((boolean)this.getOutput(this.exec_result).contains("lion"));
        }
        finally {
            cal = Calendar.getInstance();
            cal.add(12, -59);
            KatelloUtils.sshOnServer("date -s " + tformat.format(new Date(cal.getTimeInMillis())));
        }
    }

    private KatelloSyncPlan createSyncPlan(Date date, KatelloSyncPlan.SyncPlanInterval interval) {
        String uid = KatelloTestScript.getUniqueID();
        String spName = "splan" + uid;
        SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat tformat = new SimpleDateFormat("HH:mm:ss");
        KatelloSyncPlan sp = new KatelloSyncPlan(spName, this.org_name, null, dformat.format(date), tformat.format(date), interval);
        this.exec_result = sp.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        return sp;
    }

    private void createZooReport() {
        this.uid = KatelloTestScript.getUniqueID();
        this.org_name = "org" + this.uid;
        this.user_name = "user" + this.uid;
        this.provider_name = "provider" + this.uid;
        this.product_name = "product" + this.uid;
        this.repo_name = "repo" + this.uid;
        this.env_name = "env" + this.uid;
        this.changeset_name = "changeset" + this.uid;
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUser user = new KatelloUser(this.user_name, "root@localhost", "testing", false);
        this.exec_result = user.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", null);
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = this.prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, "http://inecas.fedorapeople.org/fakerepos/zoo3/", null, null);
        this.exec_result = this.repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloChangeset cs = new KatelloChangeset(this.changeset_name, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    private void createLocalReport() {
        this.uid = KatelloTestScript.getUniqueID();
        this.org_name = "org" + this.uid;
        this.user_name = "user" + this.uid;
        this.provider_name = "provider" + this.uid;
        this.product_name = "product" + this.uid;
        this.repo_name = "repo" + this.uid;
        this.env_name = "env" + this.uid;
        this.changeset_name = "changeset" + this.uid;
        this.repo_path = "/var/www/html/" + this.uid;
        this.repo_url = "http://localhost/" + this.uid;
        KatelloUtils.sshOnServer("yum install createrepo");
        KatelloUtils.sshOnServer("mkdir /tmp/" + this.uid);
        KatelloUtils.sshOnServer("createrepo " + this.repo_path);
        KatelloUtils.sshOnServer("wget http://inecas.fedorapeople.org/fakerepos/zoo3/wolf-9.4-2.noarch.rpm -P " + this.repo_path);
        KatelloUtils.sshOnServer("wget http://inecas.fedorapeople.org/fakerepos/zoo3/walrus-0.71-1.noarch.rpm -P " + this.repo_path);
        KatelloUtils.sshOnServer("createrepo " + this.repo_path);
        KatelloOrg org = new KatelloOrg(this.org_name, "Package tests");
        this.exec_result = org.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloUser user = new KatelloUser(this.user_name, "root@localhost", "testing", false);
        this.exec_result = user.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(this.provider_name, this.org_name, "Package provider", null);
        this.exec_result = prov.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.prod = new KatelloProduct(this.product_name, this.org_name, this.provider_name, null, null, null, null, null);
        this.exec_result = this.prod.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.repo = new KatelloRepo(this.repo_name, this.org_name, this.product_name, this.repo_url, null, null);
        this.exec_result = this.repo.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, null, this.org_name, "Library");
        this.exec_result = env.cli_create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloChangeset cs = new KatelloChangeset(this.changeset_name, this.org_name, this.env_name);
        this.exec_result = cs.create();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = prov.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = this.prod.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        this.exec_result = this.repo.synchronize();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        cs.update_addProduct(this.product_name);
        this.exec_result = cs.promote();
        Assert.assertTrue((this.exec_result.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    private void updateLocalRepo() {
        KatelloUtils.sshOnServer("wget http://inecas.fedorapeople.org/fakerepos/zoo3/lion-0.4-1.noarch.rpm  -P " + this.repo_path);
        KatelloUtils.sshOnServer("rm " + this.repo_path + "/walrus-0.71-1.noarch.rpm -f");
        KatelloUtils.sshOnServer("createrepo " + this.repo_path);
    }
}

