/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.cli;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCliDataProvider;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-cli"})
public class ProviderTests
extends KatelloCliTestScript {
    private String org_name;

    @BeforeClass(description="Prepare an org to work with", groups={"cli-providers"})
    public void setup_org() {
        String uid = KatelloTestScript.getUniqueID();
        this.org_name = "org" + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
    }

    @Test(description="Fresh org - check default provider status/info", groups={"cli-providers"}, enabled=true)
    public void test_freshOrgDefaultRedHatProvider() {
        String uid = KatelloTestScript.getUniqueID();
        String tmpOrg = "tmpOrg" + uid;
        KatelloOrg org = new KatelloOrg(tmpOrg, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(null, tmpOrg, null, null);
        res = prov.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_PROVIDER_REDHAT = ".*Id:\\s+\\d+.*Name:\\s+Red Hat.*Type:\\s+Red\\sHat.*Url:\\s+https://cdn.redhat.com.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_PROVIDER_REDHAT), (String)"Provider \"Red Hat\" should be found in the providers list");
        prov = new KatelloProvider("Red Hat", tmpOrg, null, null);
        res = prov.status();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_REDHAT_STATUS = ".*Id:\\s+\\d+.*Name:\\s+Red Hat.*Last\\sSync:\\s+never.*Sync\\sState:\\s+Not\\ssynced.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REDHAT_STATUS), (String)"Provider \"Red Hat\" should have sync status: never");
        res = new KatelloOrg(this.org_name, null).cli_info();
        String orgId = KatelloTasks.grepCLIOutput("Id", this.getOutput(res));
        prov = new KatelloProvider("Red Hat", this.org_name, null, null);
        res = prov.info();
        String REGEXP_REDHAT_INFO = ".*Id:\\s+\\d+.*Name:\\s+Red Hat.*Type:\\s+Red Hat.*Url:\\s+https://cdn.redhat.com.*Org Id:\\s+" + orgId + ".*Description:.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REDHAT_INFO), (String)"Provider \"Red Hat\" info should be displayed together with org_id");
    }

    @Test(description="Create custom provider - different inputs", groups={"cli-providers"}, dataProvider="provider_create", dataProviderClass=KatelloCliDataProvider.class, enabled=true)
    public void test_createProvider_output(String name, String descr, String url, Integer exitCode, String output) {
        KatelloProvider prov;
        SSHCommandResult res;
        String cmd = "provider create --org " + this.org_name;
        if (name != null) {
            cmd = cmd + " --name \"" + name + "\"";
        }
        if (descr != null) {
            cmd = cmd + " --description \"" + descr + "\"";
        }
        if (url != null) {
            cmd = cmd + " --url \"" + url + "\"";
        }
        Assert.assertTrue(((res = (prov = new KatelloProvider(name, this.org_name, descr, url)).create()).getExitCode().intValue() == exitCode.intValue() ? 1 : 0) != 0, (String)"Check - return code");
        if (exitCode == 0) {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned output string");
        } else {
            Assert.assertTrue((boolean)this.getOutput(res).contains(output), (String)"Check - returned error string");
        }
    }

    @Test(description="Delete provider - Red Hat", groups={"cli-providers"}, enabled=true)
    public void test_deleteProvider_RedHat() {
        String uid = KatelloTestScript.getUniqueID();
        String orgName = "delRH" + uid;
        KatelloOrg org = new KatelloOrg(orgName, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider("Red Hat", this.org_name, null, null);
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 147 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)"User admin is not allowed to access api/providers/destroy", (String)"Check - returned error string");
        res = prov.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(".*Name:\\s+Red Hat.*"), (String)"Check - returned output string");
    }

    @Test(description="Delete provider Custom - missing parameters", groups={"cli-providers"}, enabled=false)
    public void test_deleteProvider_missingReqParams() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "delProv-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, null);
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        prov = new KatelloProvider(null, null, null, null);
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 2 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("Option --org is required; please see --help"), (String)"Check - returned error string - 1");
        Assert.assertTrue((boolean)this.getOutput(res).contains("Option --name is required; please see --help"), (String)"Check - returned error string - 2");
        prov = new KatelloProvider(null, this.org_name, null, null);
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 2 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("Option --name is required; please see --help"), (String)"Check - returned error string");
        prov = new KatelloProvider(provName, null, null, null);
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 2 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("Option --org is required; please see --help"), (String)"Check - returned error string");
        prov = new KatelloProvider(null, "", null, null);
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 2 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("katello: error: --org option requires an argument"), (String)"Check - returned error string");
        prov = new KatelloProvider("", this.org_name, null, null);
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 2 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("katello: error: --name option requires an argument"), (String)"Check - returned error string");
    }

    @Test(description="Delete provider Custom - different org", groups={"cli-providers"}, enabled=true)
    public void test_deleteProvider_diffOrg() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "delProv-" + uid;
        String org1 = "anotherOrg" + uid;
        KatelloOrg org = new KatelloOrg(org1, null);
        SSHCommandResult res = org.cli_create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, null);
        res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        prov = new KatelloProvider(provName, org1, null, null);
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains("Could not find provider [ " + provName + " ] within organization [ " + org1 + " ]"), (String)"Check - returned error string");
    }

    @Test(description="Delete provider Custom - no products associated", groups={"cli-providers"}, enabled=true)
    public void test_deleteProvider_noProducts() {
        String uid = KatelloTestScript.getUniqueID();
        KatelloProvider prov = new KatelloProvider("noProd-" + uid, this.org_name, null, null);
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).equals("Deleted provider [ " + prov.name + " ]"), (String)"Check - returned output string");
        this.assert_providerRemoved(prov);
        res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)("Successfully created provider [ " + prov.name + " ]"));
    }

    @Test(description="Delete provider Custom - with products associated", groups={"cli-providers"}, enabled=true)
    public void test_deleteProvider_noRepos() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "noRepos-" + uid;
        String provName_1 = "prov1-" + uid;
        String prodName = "prod-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, null);
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, provName, null, null, null, null, null);
        res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.delete();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Deleted provider [ %s ]", provName)), (String)"Check - returned output string");
        this.assert_providerRemoved(prov);
        res = prod.status();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Could not find product [ %s ] within organization [ %s ]", prodName, this.org_name)), (String)"Check - `product status` output string");
        prov = new KatelloProvider(provName_1, this.org_name, null, null);
        res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod1 = new KatelloProduct(prodName, this.org_name, provName_1, null, null, null, null, null);
        res = prod1.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_PRODUCT = ".*Id:\\s+\\d+.*Name:\\s+%s.*Provider Id:\\s+\\d+.*Provider Name:\\s+%s.*";
        res = prod.status();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String match_info = String.format(REGEXP_PRODUCT, prodName, provName_1).replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the result of product info for: [%s]", provName_1, prodName));
    }

    public void test_deleteProvider_withRepos() {
    }

    @Test(description="List / Info providers - no description, no url", groups={"cli-providers"}, enabled=true)
    public void test_listNinfoProviders_noDesc_noUrl() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "listProv1-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, null);
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_PROVIDER_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Type:\\s+Custom.*Url:\\s+None.*Description:\\s+None";
        String match_info = String.format(REGEXP_PROVIDER_LIST, provName).replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the list with: no description, no url", provName));
        res = prov.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        match_info = String.format(REGEXP_PROVIDER_LIST, provName).replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the info with: no description, no url", provName));
    }

    @Test(description="List / Info providers", groups={"cli-providers"}, enabled=true)
    public void test_listNinfoProviders() {
        String provDesc;
        String uid = KatelloTestScript.getUniqueID();
        String provName = "listProv1-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, provDesc = "Simple description", "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/");
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_PROVIDER_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Type:\\s+Custom.*Url:\\s+%s.*Description:\\s+%s.*";
        String match_info = String.format(REGEXP_PROVIDER_LIST, provName, "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/", provDesc).replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the list", provName));
        res = prov.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        match_info = String.format(REGEXP_PROVIDER_LIST, provName, "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/", provDesc).replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the info", provName));
    }

    @Test(description="List / Info providers - no description", groups={"cli-providers"}, enabled=true)
    public void test_listNinfoProviders_noDesc() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "listProvURL-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/");
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.cli_list();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_PROVIDER_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Type:\\s+Custom.*Url:\\s+%s.*Description:\\s+None";
        String match_info = String.format(REGEXP_PROVIDER_LIST, provName, "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/").replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the list with: no description", provName));
        res = prov.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        match_info = String.format(REGEXP_PROVIDER_LIST, provName, "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/").replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the info with: no description", provName));
    }

    @Test(description="Synchronize provider - no products", groups={"cli-providers"}, enabled=true)
    public void test_syncProvider_noProduct() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "syncNoProd-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, null);
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).equals(String.format("Provider [ %s ] synchronized", provName)), (String)"Check - returned output string");
    }

    @Test(description="Synchronize provider - single product", groups={"cli-providers"}, enabled=true)
    public void test_syncProvider_singleProduct() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "syncNoProd-" + uid;
        String prodName = "prod1Repo-" + uid;
        String repoName = "pulpF15_64bit-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, null);
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod = new KatelloProduct(prodName, this.org_name, provName, null, null, null, null, null);
        res = prod.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo = new KatelloRepo(repoName, this.org_name, prodName, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, null);
        repo.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Provider [ %s ] synchronized", provName)), (String)"Check - returned output string");
        this.assert_repoSynced(repo);
    }

    @Test(description="Synchronize provider - multiple products", groups={"cli-providers"}, enabled=true)
    public void test_syncProvider_multiProducts() {
        String uid = KatelloTestScript.getUniqueID();
        String provName = "syncNoProd-" + uid;
        String prodName1 = "pulpF15_64bit" + uid;
        String prodName2 = "pulpF15_32bit" + uid;
        String repoName1 = "pulpF15_64bit-" + uid;
        String repoName2 = "pulpF15_32bit-" + uid;
        KatelloProvider prov = new KatelloProvider(provName, this.org_name, null, null);
        SSHCommandResult res = prov.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod1 = new KatelloProduct(prodName1, this.org_name, provName, null, null, null, null, null);
        res = prod1.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloProduct prod2 = new KatelloProduct(prodName2, this.org_name, provName, null, null, null, null, null);
        res = prod2.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo1 = new KatelloRepo(repoName1, this.org_name, prodName1, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/x86_64/", null, null);
        res = repo1.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        KatelloRepo repo2 = new KatelloRepo(repoName2, this.org_name, prodName2, "http://repos.fedorapeople.org/repos/pulp/pulp/v1/stable/fedora-16/i386/", null, null);
        res = repo2.create();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        res = prov.synchronize();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Provider [ %s ] synchronized", provName)), (String)"Check - returned output string");
        this.assert_repoSynced(repo1);
        this.assert_repoSynced(repo2);
    }

    @Test(description="Try to updateRed Hat provider - name", groups={"cli-providers"}, enabled=true)
    public void test_updateProvider_RedHat_name() {
        KatelloProvider prov = new KatelloProvider("Red Hat", this.org_name, null, null);
        SSHCommandResult res = prov.update("REDHAT", null, null);
        Assert.assertTrue((res.getExitCode() == 144 ? 1 : 0) != 0, (String)"Check - return code (provider update)");
        Assert.assertTrue((boolean)this.getOutput(res).contains("Validation failed: the following attributes can not be updated for the Red Hat provider: [ name ]"), (String)"Check - returned error string (provider update)");
    }

    @Test(description="Try to updateRed Hat provider - url", groups={"cli-providers"}, dependsOnMethods={"test_freshOrgDefaultRedHatProvider"}, enabled=true)
    public void test_updateProvider_RedHat_url() {
        KatelloProvider prov = new KatelloProvider("Red Hat", this.org_name, null, null);
        String update_url = "https://localhost:443";
        SSHCommandResult res = prov.update(null, update_url, null);
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (provider update)");
        Assert.assertTrue((boolean)this.getOutput(res).contains(String.format("Successfully updated provider [ %s ]", "Red Hat")), (String)"Check - returned error string (provider update)");
        res = prov.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_PROVIDER_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Type:\\s+.*Url:\\s+%s.*";
        String match_info = String.format(REGEXP_PROVIDER_LIST, "Red Hat", update_url).replaceAll("\"", "");
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Provider [%s] should be found in the info", "Red Hat"));
    }
}

