/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.redhat.qe.auto.testng.Assert;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.logging.Logger;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Z_InitScriptLSBTest
extends KatelloTestScript {
    private static final String KATELLO_SERVICENAME = "katello";
    private static final String DAEMON_PID = "/usr/lib/katello/tmp/pids/server.pid";
    protected static Logger log = Logger.getLogger(Z_InitScriptLSBTest.class.getName());

    @BeforeClass
    public void setUp() {
        this.servertasks.execute_remote(String.format("service %s stop; killall -9 ruby", KATELLO_SERVICENAME));
        this.servertasks.execute_remote("useradd testuserqa");
        this.servertasks.execute_remote(String.format("service %s start", KATELLO_SERVICENAME));
        this.servertasks.waitfor_katello();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.servertasks.execute_remote("userdel -fr testuserqa");
        this.servertasks.execute_remote(String.format("killall -9 ruby; service %s start", KATELLO_SERVICENAME));
        this.servertasks.waitfor_katello();
    }

    @Test(description="Katello service start", enabled=false)
    public void test_serviceStart() {
        this.servertasks.execute_remote(String.format("service %s stop", KATELLO_SERVICENAME));
        SSHCommandResult res = this.servertasks.execute_remote(String.format("service %s start", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Service must start without problem");
        res = this.servertasks.execute_remote(String.format("service %s status", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Then Status command");
        res = this.servertasks.execute_remote(String.format("service %s start", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Already started service");
        res = this.servertasks.execute_remote(String.format("service %s status", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Again status command");
    }

    @Test(description="Katello service restart")
    public void test_serviceRestart() {
        this.servertasks.execute_remote(String.format("service %s stop; killall -9 ruby", KATELLO_SERVICENAME));
        SSHCommandResult res = this.servertasks.execute_remote(String.format("service %s restart", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Restarting of service (from stopped mode)");
        res = this.servertasks.execute_remote(String.format("service %s status", KATELLO_SERVICENAME));
        this.servertasks.execute_remote(String.format("service %s stop; killall -9 ruby", KATELLO_SERVICENAME));
        this.servertasks.execute_remote(String.format("service %s start", KATELLO_SERVICENAME));
        res = this.servertasks.execute_remote(String.format("service %s restart", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Restarting of service (from started mode)");
        res = this.servertasks.execute_remote(String.format("service %s status", KATELLO_SERVICENAME));
    }

    @Test(description="Katello service stop")
    public void test_serviceStop() {
        this.servertasks.execute_remote(String.format("service %s restart", KATELLO_SERVICENAME));
        SSHCommandResult res = this.servertasks.execute_remote(String.format("service %s stop", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Stopping service)");
        res = this.servertasks.execute_remote(String.format("service %s status", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(3), (String)"Status of stopped service");
        res = this.servertasks.execute_remote(String.format("service %s stop", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)"Stopping service again)");
        res = this.servertasks.execute_remote(String.format("service %s status", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(3), (String)"Status of stopped service");
    }

    @Test(description="Katello pid file", enabled=false)
    public void test_pidFile() {
        this.servertasks.execute_remote(String.format("service %s restart", KATELLO_SERVICENAME));
        SSHCommandResult res = this.servertasks.execute_remote(String.format("ls %s", DAEMON_PID));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(0), (String)String.format("Pid file [%s] must exist", DAEMON_PID));
        this.servertasks.execute_remote("killall -9 ruby");
        res = this.servertasks.execute_remote(String.format("service %s status", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(1), (String)"Existing pid file, but service not started");
        this.servertasks.execute_remote(String.format("rm -fv %s", DAEMON_PID));
    }

    @Test(description="Katello insufficient rights", enabled=false)
    public void test_insuffRights() {
        this.servertasks.execute_remote(String.format("service %s restart", KATELLO_SERVICENAME));
        SSHCommandResult res = this.servertasks.execute_remote(String.format("su testuserqa -c 'service %s stop'", KATELLO_SERVICENAME));
        Assert.assertEquals((Object)res.getExitCode(), (Object)new Integer(4), (String)"Insufficient rights, stopping service under nonprivileged user must fail");
    }
}

