/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloUser;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.testng.annotations.Test;

@Test(groups={"cfse-api"})
public class UsersTest
extends KatelloTestScript {
    protected static Logger log = Logger.getLogger(UsersTest.class.getName());
    private String username_disabled;
    private String username_enabled;
    private Long userid_disabled;

    @Test(groups={"testUsers"}, description="Create user (disabled)")
    public void test_createUserDisabled() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        String pid = KatelloTestScript.getUniqueID();
        this.username_disabled = "user_" + pid;
        KatelloUser user = new KatelloUser(this.username_disabled, "root@localhost", "testing", true);
        String s = user.api_create();
        JSONObject juser = KatelloTestScript.toJSONObj(s);
        Assert.assertNotNull((Object)juser.get((Object)"id"), (String)"Check: not null returned: id");
        Boolean disabled = (Boolean)juser.get((Object)"disabled");
        Assert.assertTrue((boolean)disabled, (String)"Check: returned value: disabled=true");
        this.userid_disabled = (Long)juser.get((Object)"id");
        log.info("Preparing disabled user: [" + this.username_disabled + "]");
    }

    @Test(groups={"testUsers"}, description="Create user (enabled)")
    public void test_createUserEnabled() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        String pid = KatelloTestScript.getUniqueID();
        this.username_enabled = "user_" + pid;
        KatelloUser user = new KatelloUser(this.username_enabled, "root@localhost", "testing", false);
        String s = user.api_create();
        JSONObject juser = KatelloTestScript.toJSONObj(s);
        Assert.assertNotNull((Object)juser.get((Object)"id"), (String)"Check: not null returned: id");
        Boolean disabled = (Boolean)juser.get((Object)"disabled");
        Assert.assertFalse((boolean)disabled, (String)"Check: returned value: disabled=false");
        log.info("Preparing enabled user: [" + this.username_enabled + "]");
    }

    @Test(dependsOnMethods={"test_createUserDisabled", "test_createUserEnabled"}, groups={"testUsers"}, description="Get all users")
    public void test_getUsers() {
        String _ret = new KatelloUser(null, null, null, false).api_list();
        Assert.assertTrue((boolean)_ret.contains("\"username\":\"admin\""), (String)"Check: \"admin\" user exists");
        JSONArray users = KatelloTestScript.toJSONArr(_ret);
        boolean userFound_D = false;
        boolean userFound_E = false;
        for (int i = 0; i < users.size(); ++i) {
            JSONObject tmpUsr = (JSONObject)users.get(i);
            if (tmpUsr.get((Object)"username").equals(this.username_enabled)) {
                userFound_E = true;
                Assert.assertFalse((boolean)((Boolean)tmpUsr.get((Object)"disabled")), (String)"Check: enabled user's disabled flag.");
            }
            if (!tmpUsr.get((Object)"username").equals(this.username_disabled)) continue;
            userFound_D = true;
            Assert.assertTrue((boolean)((Boolean)tmpUsr.get((Object)"disabled")), (String)"Check: disabled user's disabled flag.");
        }
        Assert.assertTrue((userFound_D && userFound_E ? 1 : 0) != 0, (String)"Check: both users should be found in the list");
    }

    @Test(dependsOnMethods={"test_createUserDisabled", "test_createUserEnabled"}, groups={"testUsers"}, description="Get user")
    public void test_getUser() {
        String _ret = new KatelloUser(null, null, null, false).api_info(this.userid_disabled.toString());
        Assert.assertTrue((boolean)_ret.contains("\"username\":\"" + this.username_disabled + "\""), (String)"Check: returned username");
        Assert.assertTrue((boolean)_ret.contains("\"disabled\":true"), (String)"Check: returned username's disabled status");
    }

    @Test(groups={"testUsers"}, description="Update user properties")
    public void test_updateUser() {
        String pid = KatelloTestScript.getUniqueID();
        String updUser = "updUser_" + pid;
        KatelloUser user = new KatelloUser(updUser, "root@localhost", "testing", false);
        String s = user.api_create();
        JSONObject juser = KatelloTestScript.toJSONObj(s);
        Long userId = (Long)juser.get((Object)"id");
        String pwdHash = (String)juser.get((Object)"password");
        try {
            this.servertasks.apiKatello_PUT("{'user':{'disabled':true}}", "/users/" + userId.toString());
            String _ret = new KatelloUser(null, null, null, false).api_info(userId.toString());
            Assert.assertTrue((boolean)_ret.contains("\"disabled\":true"), (String)"Check: updated disable status");
            this.servertasks.apiKatello_PUT("{'user':{'password':'123456'}}", "/users/" + userId.toString());
            _ret = new KatelloUser(null, null, null, false).api_info(userId.toString());
            Assert.assertFalse((boolean)_ret.contains("\"password\":\"" + pwdHash + "\""), (String)"Check: updated password");
        }
        catch (IOException ie) {
            log.severe(ie.getMessage());
        }
    }

    @Test(groups={"testUsers"}, description="Delete user")
    public void test_deleteUser() {
        String pid = KatelloTestScript.getUniqueID();
        String updUser = "delUser_" + pid;
        KatelloUser user = new KatelloUser(updUser, "root@localhost", "testing", false);
        String s = user.api_create();
        JSONObject juser = KatelloTestScript.toJSONObj(s);
        Long userId = (Long)juser.get((Object)"id");
        try {
            String _ret = this.servertasks.apiKatello_DELETE("/users/" + userId.toString()).trim();
            Assert.assertEquals((String)_ret, (String)String.format("Deleted user '%s'", userId.toString()), (String)"Check: returned message of delete command");
            _ret = new KatelloUser(null, null, null, false).api_info(userId.toString());
            Assert.assertTrue((boolean)_ret.contains(String.format("Couldn't find User with ID=%s", userId.toString())), (String)"Check: returned error message - getUsers()");
        }
        catch (IOException ie) {
            log.severe(ie.getMessage());
        }
    }
}

