/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-api"})
public class ProvidersTest
extends KatelloTestScript {
    protected static Logger log = Logger.getLogger(ProvidersTest.class.getName());
    private String org_name;
    private String provider_name;

    @BeforeClass(description="Prepare an organization to work with")
    public void setUp_createOrg() {
        this.org_name = default_org;
    }

    @Test(groups={"testProviders"}, description="Create provider")
    public void test_createProvider() {
        String uid = ProvidersTest.getUniqueID();
        this.provider_name = "auto-provider-" + uid;
        String str_json = this.servertasks.createProvider(this.org_name, this.provider_name, "Provider in test - " + uid, "Custom");
        JSONObject json_prov = KatelloTestScript.toJSONObj(str_json);
        Assert.assertNotNull((Object)json_prov, (String)"Returned string in katello is JSON-formatted");
        Assert.assertEquals((Object)json_prov.get((Object)"name"), (Object)this.provider_name, (String)"Katello - Check provider: name");
        Assert.assertEquals((Object)json_prov.get((Object)"description"), (Object)("Provider in test - " + uid), (String)"Katello - Check provider: description");
        Assert.assertEquals((Object)json_prov.get((Object)"provider_type"), (Object)"Custom", (String)"Katello - Check provider: provider_type");
        JSONObject json_org = KatelloTestScript.toJSONObj(new KatelloOrg(this.org_name, null).api_info());
        Assert.assertEquals((Object)json_prov.get((Object)"organization_id"), (Object)json_org.get((Object)"id"), (String)"Katello - Check provider: organization_id");
    }

    @Test(groups={"testProviders"}, description="Import Products", dependsOnMethods={"test_createProvider"}, enabled=false)
    public void test_importProducts() {
        String sProducts = "{}";
        try {
            BufferedReader br = new BufferedReader(new FileReader("data/product.json"));
            sProducts = br.readLine();
            br.close();
        }
        catch (IOException iex) {
            log.severe(iex.getMessage());
            throw new RuntimeException(iex);
        }
        String pid = KatelloTestScript.getUniqueID();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        String cid = KatelloTestScript.getUniqueID();
        String repoUrl = "http://repos.fedorapeople.org/repos/katello/katello/fedora-15/x86_64/";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.000+0000'");
        String sTS = df.format(Calendar.getInstance().getTime());
        sProducts = sProducts.replaceAll("\\$\\{product_id\\}", pid);
        sProducts = sProducts.replaceAll("\\$\\{content_id\\}", cid);
        sProducts = sProducts.replaceAll("\\$\\{content_url\\}", repoUrl);
        sProducts = sProducts.replaceAll("\\$\\{product_create_ts\\}", sTS);
        log.finest("Replaced data/products.json: [" + sProducts + "]");
        JSONObject json_prov = this.servertasks.getProvider(this.org_name, this.provider_name);
        String prov_id = ((Long)json_prov.get((Object)"id")).toString();
        String s = this.servertasks.import_products(prov_id, sProducts);
        Assert.assertEquals((boolean)s.equals("[true]"), (boolean)true, (String)"Returned output should be: [true]");
    }

    @Test(groups={"testProviders"}, description="Update Provider Properties", dependsOnMethods={"test_createProvider"})
    public void test_updateProvider() {
        JSONObject json_updProv = this.servertasks.getProvider(this.org_name, this.provider_name);
        String upd_repo_url = "https://localhost";
        try {
            Date dupBefore = this.parseKatelloDate((String)json_updProv.get((Object)"updated_at"));
            json_updProv = this.updateProviderProperty("name", "modified-" + this.provider_name);
            Date dupAfter = this.parseKatelloDate((String)json_updProv.get((Object)"updated_at"));
            Assert.assertEquals((Object)json_updProv.get((Object)"name"), (Object)("modified-" + this.provider_name), (String)"Check updated: name");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
            this.provider_name = "modified-" + this.provider_name;
            dupBefore = dupAfter;
            json_updProv = this.updateProviderProperty("repository_url", upd_repo_url);
            dupAfter = this.parseKatelloDate((String)json_updProv.get((Object)"updated_at"));
            Assert.assertEquals((Object)json_updProv.get((Object)"repository_url"), (Object)upd_repo_url, (String)"Check updated: repository_url");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
            dupBefore = dupAfter;
            json_updProv = this.updateProviderProperty("description", "Updated: provider [" + this.provider_name + "]");
            dupAfter = this.parseKatelloDate((String)json_updProv.get((Object)"updated_at"));
            Assert.assertEquals((Object)json_updProv.get((Object)"description"), (Object)("Updated: provider [" + this.provider_name + "]"), (String)"Check updated: description");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
        }
        catch (ParseException pex) {
            log.severe(pex.getMessage());
        }
    }

    @Test(groups={"testProviders"}, description="List all providers", dependsOnMethods={"test_updateProvider"})
    public void test_listProviders() {
        String s_json_provs = new KatelloProvider(null, this.org_name, null, null).api_list(this.org_name);
        JSONArray arr_provs = KatelloTestScript.toJSONArr(s_json_provs);
        Assert.assertMore((Comparable)Integer.valueOf(arr_provs.size()), (Comparable)Integer.valueOf(0), (String)"Check: providers count >0");
        boolean findOurProvider = false;
        for (int i = 0; i < arr_provs.size(); ++i) {
            JSONObject json_prov = (JSONObject)arr_provs.get(i);
            if (!json_prov.get((Object)"name").equals(this.provider_name)) continue;
            findOurProvider = true;
        }
        Assert.assertTrue((boolean)findOurProvider, (String)"Check: we found our provider");
    }

    @Test(groups={"testProviders"}, description="Delete provider", enabled=true)
    public void test_deleteProvider() {
        String uid = ProvidersTest.getUniqueID();
        String providerName = "auto-deleteMe-" + uid;
        String str_json = this.servertasks.createProvider(this.org_name, providerName, "Provider in test - " + uid, "Custom");
        JSONObject json_prov = KatelloTestScript.toJSONObj(str_json);
        Assert.assertNotNull((Object)json_prov, (String)"Returned string in katello is JSON-formatted");
        String sout = this.servertasks.deleteProvider(this.org_name, providerName).trim();
        Assert.assertEquals((String)sout, (String)("Deleted provider [ " + providerName + " ]"), (String)"Check: message returned by the API call");
        JSONObject obj_del = this.servertasks.getProvider(this.org_name, providerName);
        Assert.assertNull((Object)obj_del, (String)"Check: returned getProvider() is null");
    }

    @Test(groups={"testOrgs", "testProviders"}, description="Generate ", enabled=false)
    public void test_postUeberCert() {
        try {
            String _return = this.servertasks.apiKatello_POST("", "/organizations/org1/uebercert");
            log.info("Posting ueber cert for: [org1]");
            System.out.println(_return);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private JSONObject updateProviderProperty(String component, String updValue) {
        JSONObject _return = null;
        String updProv = String.format("'provider':{'%s':'%s'}", component, updValue);
        String provider_id = ((Long)this.servertasks.getProvider(this.org_name, this.provider_name).get((Object)"id")).toString();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String retStr = this.servertasks.apiKatello_PUT(updProv, String.format("/providers/%s", provider_id));
            _return = KatelloTestScript.toJSONObj(retStr);
        }
        catch (IOException ie) {
            log.severe(ie.getMessage());
        }
        return _return;
    }
}

