/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"cfse-api"})
public class EnvironmentsTest
extends KatelloTestScript {
    private String org_name;
    private String env_name;
    protected static Logger log = Logger.getLogger(EnvironmentsTest.class.getName());

    @BeforeClass(description="Prepare an organization to work with", alwaysRun=true)
    public void setUp_createOrg() {
        String uid = KatelloTestScript.getUniqueID();
        this.org_name = "auto-org-" + uid;
        String org_descr = "Test Organization " + uid;
        KatelloOrg org = new KatelloOrg(this.org_name, org_descr);
        org.api_create();
    }

    @Test(groups={"testEnvs"}, description="Existance of root env created by default", dependsOnMethods={"test_createEnvironment_priorLocker"})
    public void test_existsDefaultRoot() {
        KatelloEnvironment env = new KatelloEnvironment(null, null, this.org_name, null);
        JSONArray json = EnvironmentsTest.toJSONArr(env.api_list());
        log.finer("Returned JSON for getEnvironments(): " + json.toJSONString());
        JSONObject json_org = KatelloTestScript.toJSONObj(new KatelloOrg(this.org_name, null).api_info());
        log.finer("Returned JSON for getOrganization(): " + json_org.toJSONString());
        JSONObject json_root = null;
        for (int i = 0; i < json.size(); ++i) {
            JSONObject tmpEnv = (JSONObject)json.get(i);
            if (!tmpEnv.get((Object)"name").equals("root")) continue;
            json_root = tmpEnv;
        }
        Assert.assertNotNull((Object)json, (String)"JSON object returned should be: [!null]");
        Assert.assertNull(json_root, (String)"JSON root object parsed should be: [null]");
        Assert.assertMore((Comparable)Integer.valueOf(json.size()), (Comparable)Integer.valueOf(0), (String)"Should contain environments count: [>0]");
    }

    @Test(groups={"testEnvs"}, description="List environments should be greater than 0")
    public void test_showEnvironments() {
        JSONArray json_envs = EnvironmentsTest.toJSONArr(new KatelloEnvironment(null, null, this.org_name, null).api_list());
        log.finer(String.format("Returned environments count is: [%s]", json_envs.size()));
        Assert.assertMore((Comparable)Integer.valueOf(json_envs.size()), (Comparable)Integer.valueOf(0), (String)"Should return environments >0");
    }

    @Test(groups={"testEnvs"}, description="Create an environment")
    public void test_createEnvironment_priorLocker() {
        String uid = KatelloTestScript.getUniqueID();
        this.env_name = "auto-env-" + uid;
        String env_descr = "Test Environment " + uid;
        KatelloEnvironment env = new KatelloEnvironment(this.env_name, env_descr, this.org_name, "Library");
        env.api_create();
        JSONObject json_env = this.servertasks.getEnvFromOrgList(this.org_name, this.env_name);
        Assert.assertNotNull((Object)json_env, (String)"Should be in envs. list of the organization");
    }

    @Test(groups={"testEnvs"}, description="List an environment", dependsOnMethods={"test_createEnvironment_priorLocker"})
    public void test_listEnvironment() {
        JSONObject json_env = this.servertasks.getEnvironment(this.org_name, this.env_name);
        Assert.assertEquals((Object)this.env_name, (Object)json_env.get((Object)"name"), (String)"Check: name");
        JSONObject json_org = KatelloTestScript.toJSONObj(new KatelloOrg(this.org_name, null).api_info());
        Assert.assertEquals((Object)json_org.get((Object)"id"), (Object)json_env.get((Object)"organization_id"), (String)"Check: organization_id");
    }

    @Test(groups={"testEnvs"}, description="Update environment properties", dependsOnMethods={"test_listEnvironment"})
    public void test_updateEnvironment() {
        JSONObject json_env = this.servertasks.getEnvironment(this.org_name, this.env_name);
        try {
            Date dupBefore = this.parseKatelloDate((String)json_env.get((Object)"updated_at"));
            JSONObject json_updEnv = this.updateEnvProperty("description", "Updated environment description");
            Date dupAfter = this.parseKatelloDate((String)json_updEnv.get((Object)"updated_at"));
            Assert.assertEquals((Object)json_updEnv.get((Object)"description"), (Object)"Updated environment description", (String)"Check updated: description");
            Assert.assertMore((Comparable)Long.valueOf(dupAfter.getTime()), (Comparable)Long.valueOf(dupBefore.getTime()), (String)"Check the timestamp updated");
            String uid = KatelloTestScript.getUniqueID();
            String env_prior = "dev-" + uid;
            KatelloEnvironment env = new KatelloEnvironment(env_prior, "Prior: " + env_prior, this.org_name, "Library");
            env.api_create();
            JSONObject json_prior = this.servertasks.getEnvironment(this.org_name, env_prior);
            dupBefore = dupAfter;
            String updEnv = String.format("'environment':{'prior':'%s'}", ((Long)json_prior.get((Object)"id")).toString());
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String env_id = ((Long)this.servertasks.getEnvironment(this.org_name, this.env_name).get((Object)"id")).toString();
            try {
                String res = this.servertasks.apiKatello_PUT(updEnv, String.format("/organizations/%s/environments/%s", this.org_name, env_id));
                json_updEnv = KatelloTestScript.toJSONObj(res);
                Assert.assertEquals((Object)json_updEnv.get((Object)"prior"), (Object)env_prior, (String)("Check prior is " + env_prior));
            }
            catch (IOException ie) {
                log.severe(ie.getMessage());
            }
        }
        catch (ParseException pex) {
            log.severe(pex.getMessage());
        }
    }

    @Test(groups={"testEnvs"}, description="Remove an environment created")
    public void test_deleteEnvironment() {
        String uid = KatelloTestScript.getUniqueID();
        String env_name = "remove-env-" + uid;
        String env_descr = "To Be Removed - " + uid;
        KatelloEnvironment env = new KatelloEnvironment(env_name, env_descr, this.org_name, "Library");
        env.api_create();
        String env_id = ((Long)this.servertasks.getEnvironment(this.org_name, env_name).get((Object)"id")).toString();
        String res = this.servertasks.deleteEnvironment(this.org_name, env_name).trim();
        Assert.assertEquals((String)res, (String)("Deleted environment '" + env_id + "'"), (String)"Check the text returned");
        env = new KatelloEnvironment(null, null, this.org_name, null);
        String nil = env.api_list();
        Assert.assertEquals((int)nil.indexOf(env_name), (int)-1, (String)String.format("Returned environment list does not contain: [%s]", env_name));
    }

    private JSONObject updateEnvProperty(String component, String updValue) {
        JSONObject _return = null;
        String updEnv = String.format("'environment':{'%s':'%s'}", component, updValue);
        String env_id = ((Long)this.servertasks.getEnvironment(this.org_name, this.env_name).get((Object)"id")).toString();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String retStr = this.servertasks.apiKatello_PUT(updEnv, String.format("/organizations/%s/environments/%s", this.org_name, env_id));
            _return = KatelloTestScript.toJSONObj(retStr);
        }
        catch (IOException ie) {
            log.severe(ie.getMessage());
        }
        return _return;
    }
}

