/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tests.api;

import com.redhat.qe.auto.testng.Assert;
import com.redhat.qe.katello.base.KatelloTestScript;
import java.io.IOException;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class A_ConsumersTest
extends KatelloTestScript {
    protected static Logger log = Logger.getLogger(A_ConsumersTest.class.getName());
    private String consumer_id = null;
    private String consumer_name = null;
    private String env_name = null;
    private String org_name = null;

    @BeforeClass(description="Prepare an organization to work with")
    public void setUp_createOrg() {
        String uid = KatelloTestScript.getUniqueID();
        this.org_name = "auto-org-" + uid;
        String org_descr = "Test Organization " + uid;
        this.servertasks.createOrganization(this.org_name, org_descr);
        uid = KatelloTestScript.getUniqueID();
        this.env_name = "auto-env-" + uid;
        String env_descr = "Test Environment " + uid;
        this.servertasks.createEnvironment(this.org_name, this.env_name, env_descr, "Library");
    }

    @Test(groups={"testConsumers"}, description="Create consumer")
    public void test_createConsumer() {
        String pid = KatelloTestScript.getUniqueID();
        this.consumer_name = "auto-" + pid + ".brq.redhat.com";
        String uuid = KatelloTestScript.getUUID();
        String s = this.servertasks.createConsumer(this.org_name, this.consumer_name, uuid, "data/facts-virt.json");
        JSONObject jcons = KatelloTestScript.toJSONObj(s);
        this.consumer_id = (String)jcons.get((Object)"uuid");
        Assert.assertNotNull((Object)this.consumer_id, (String)"Check returned: uuid");
        Assert.assertEquals((String)((String)jcons.get((Object)"name")), (String)this.consumer_name, (String)"Check returned: name");
        log.info("Prepared a consumer: [" + this.consumer_id + "]");
    }

    @Test(groups={"testConsumers"}, description="Retrieve consumer", dependsOnMethods={"test_createConsumer"})
    public void test_getConsumer() {
        JSONObject jcons = KatelloTestScript.toJSONObj(this.servertasks.getConsumer(this.consumer_id));
        Assert.assertEquals((String)this.consumer_id, (String)((String)jcons.get((Object)"uuid")), (String)"Check returned: uuid");
        JSONObject json_env = this.servertasks.getEnvironment(this.org_name, this.env_name);
        Assert.assertEquals((Object)((Long)json_env.get((Object)"id")), (Object)((Long)jcons.get((Object)"environment_id")), (String)"Check returned: environment_id");
        Assert.assertEquals((String)this.org_name, (String)((String)((JSONObject)jcons.get((Object)"owner")).get((Object)"displayName")), (String)"Check returned: owner.displayName");
        Assert.assertEquals((String)("/consumers/" + this.consumer_id), (String)((String)jcons.get((Object)"href")), (String)"Check returned: href");
        Assert.assertEquals((String)this.consumer_name, (String)((String)jcons.get((Object)"name")), (String)"Check returned: name");
        Assert.assertEquals((String)this.consumer_name, (String)((String)((JSONObject)jcons.get((Object)"facts")).get((Object)"network.hostname")), (String)"Check returned: facts.network.hostname");
        Assert.assertNotNull((Object)((JSONObject)jcons.get((Object)"idCert")).get((Object)"id"), (String)"Check returned: idCert.id");
    }

    @Test(groups={"testConsumers"}, description="Update consumer details", dependsOnMethods={"test_createConsumer"})
    public void test_updateConsumer() {
        String upd_component = "uname.release";
        String upd_value = "2.6.32-130.el6.i386";
        this.updateFacts(upd_component, upd_value);
        JSONObject jcons = KatelloTestScript.toJSONObj(this.servertasks.getConsumer(this.consumer_id));
        Assert.assertEquals((String)upd_value, (String)((String)((JSONObject)jcons.get((Object)"facts")).get((Object)upd_component)), (String)("Check updated: facts." + upd_component));
    }

    private JSONObject updateFacts(String component, String updValue) {
        JSONObject _return = null;
        JSONObject jfacts = (JSONObject)KatelloTestScript.toJSONObj(this.servertasks.getConsumer(this.consumer_id)).get((Object)"facts");
        jfacts.put((Object)component, (Object)updValue);
        String updConsumer = jfacts.toJSONString().replaceAll("\"", "'");
        updConsumer = "{'facts':" + updConsumer + "}";
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            log.finest(String.format("Update consumer: [%s] facts with: [%s=%s]", this.consumer_id, component, updValue));
            String retStr = this.servertasks.apiKatello_PUT(updConsumer, String.format("/consumers/%s", this.consumer_id));
            _return = KatelloTestScript.toJSONObj(retStr);
        }
        catch (IOException ie) {
            log.severe(ie.getMessage());
        }
        return _return;
    }

    @Test(groups={"testConsumers"}, description="Delete consumer", enabled=true)
    public void test_deleteConsumer() {
        String pid = KatelloTestScript.getUniqueID();
        String cname = "auto-" + pid + ".delete.me";
        String uuid = KatelloTestScript.getUUID();
        String s = this.servertasks.createConsumer(this.org_name, cname, uuid, "data/facts-virt.json");
        JSONObject jcons = KatelloTestScript.toJSONObj(s);
        String cid = (String)jcons.get((Object)"uuid");
        String ret = this.servertasks.deleteConsumer(cid);
        Assert.assertEquals((String)"", (String)ret, (String)"Check returned string (empty)");
        String sCons = this.servertasks.getConsumer(cid);
        Assert.assertTrue((boolean)sCons.contains("Couldn't find system '" + cid + "'"), (String)("Check API request to get consumer: [" + cid + "]"));
    }

    @Test(groups={"testConsumers", "rhsm-related"}, description="Import export.zip manifest", enabled=false)
    public void test_importManifest() {
        String pid = KatelloTestScript.getUniqueID();
        String prov_MF = "ExpMan_" + pid;
        this.servertasks.createProvider(this.org_name, prov_MF, "Provider for importing export.zip", "Red Hat", "https://cdn.redhat.com ");
        log.info("Check if there was another import of export.zip before.");
        if (this.servertasks.getProductByOrg(this.org_name, "Awesome OS Server Basic") == null) {
            try {
                String provider_id = ((Long)this.servertasks.getProvider(this.org_name, prov_MF).get((Object)"id")).toString();
                int prods_before = KatelloTestScript.toJSONArr(this.servertasks.getProducts(this.org_name)).size();
                String ret = this.servertasks.apiKatello_POST_manifest(EXPORT_ZIP_PATH, "/providers/" + provider_id + "/import_manifest");
                int prods_after = KatelloTestScript.toJSONArr(this.servertasks.getProducts(this.org_name)).size();
                Assert.assertEquals((String)ret, (String)"Manifest imported", (String)"Output should be: \"Manifest imported\"");
                Assert.assertTrue((prods_after - prods_before >= 6 ? 1 : 0) != 0, (String)"Check imported products: >=[6]");
            }
            catch (IOException ie) {
                log.severe(ie.getMessage());
            }
        } else {
            log.warning("Skip running of the test: test_importManifest. Cleanup DBs for this test run.");
        }
    }

    @Test(dependsOnMethods={"test_createConsumer", "test_importManifest"}, description="Subscribe consumer system to a pool", enabled=false)
    public void test_subscribeConsumer() {
        JSONObject jpool = this.servertasks.getPool("Awesome OS Server Basic");
        String pool_id = (String)jpool.get((Object)"id");
        String ret = this.servertasks.subscribeConsumer(this.consumer_id, pool_id);
        JSONObject jentl = (JSONObject)KatelloTestScript.toJSONArr(ret).get(0);
        String entitlement_id = (String)jentl.get((Object)"id");
        String certificate_id = (String)((JSONObject)((JSONArray)jentl.get((Object)"certificates")).get(0)).get((Object)"id");
        Assert.assertEquals((String)((String)((JSONObject)jentl.get((Object)"pool")).get((Object)"id")), (String)pool_id, (String)"Check returned pool id");
        Assert.assertNotNull((Object)entitlement_id, (String)"Check returned entitlement id");
        Assert.assertNotNull((Object)certificate_id, (String)"Check returned certificate id");
    }

    @Test(dependsOnMethods={"test_subscribeConsumer"}, description="Re-subscribe consumer system to a pool", enabled=false)
    public void test_resubscribeToPool() {
        JSONObject jpool = this.servertasks.getPool("Awesome OS Server Basic");
        String pool_id = (String)jpool.get((Object)"id");
        String ret = this.servertasks.subscribeConsumer(this.consumer_id, pool_id);
        Assert.assertEquals((String)ret, (String)("{\"displayMessage\":\"This consumer is already subscribed to the product matching pool with id '" + pool_id + "'\"}"));
    }

    @Test(description="Unsubscribe consumer from the pool just subscribed", enabled=false)
    public void test_unsubscribeConsumer() {
        String pid = KatelloTestScript.getUniqueID();
        String cname = "auto-" + pid + ".unsubscribed";
        String uuid = KatelloTestScript.getUUID();
        String s = this.servertasks.createConsumer(this.org_name, cname, uuid, "data/facts-virt.json");
        JSONObject jcons = KatelloTestScript.toJSONObj(s);
        String cid = (String)jcons.get((Object)"uuid");
        JSONObject jpool = this.servertasks.getPool("Awesome OS Server Basic");
        String pool_id = (String)jpool.get((Object)"id");
        this.servertasks.subscribeConsumer(cid, pool_id);
        JSONArray jserials = KatelloTestScript.toJSONArr(this.servertasks.getSerials(cid));
        Assert.assertMore((Comparable)Integer.valueOf(jserials.size()), (Comparable)Integer.valueOf(0), (String)"Serials count: >0");
        Long serial_id1 = (Long)((JSONObject)jserials.get(0)).get((Object)"serial");
        this.servertasks.unsubscribeConsumer(cid, serial_id1.toString());
        jserials = KatelloTestScript.toJSONArr(this.servertasks.getSerials(cid));
        Assert.assertEquals((int)jserials.size(), (int)0, (String)"Check no serials available: no subscriptions");
    }

    @Test(description="Unsubscribe consumer from the all pools being subscribed", enabled=false)
    public void test_unsubscribeConsumerAll() {
        String cname = "auto-" + KatelloTestScript.getUniqueID() + ".unsubscribe.all";
        String s = this.servertasks.createConsumer(this.org_name, cname, KatelloTestScript.getUUID(), "data/facts-virt.json");
        String consumer_id = (String)KatelloTestScript.toJSONObj(s).get((Object)"uuid");
        JSONArray pools = this.servertasks.getPools();
        for (int i = 0; i < pools.size(); ++i) {
            JSONObject pool = (JSONObject)pools.get(i);
            if (!((String)((JSONObject)pool.get((Object)"owner")).get((Object)"displayName")).equals(this.org_name)) continue;
            try {
                this.servertasks.subscribeConsumer(consumer_id, (String)pool.get((Object)"id"));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        JSONArray jserials = KatelloTestScript.toJSONArr(this.servertasks.getSerials(consumer_id));
        Assert.assertMore((Comparable)Integer.valueOf(jserials.size()), (Comparable)Integer.valueOf(1), (String)"Check: subscriptions should be >1");
        this.servertasks.unsubscribeConsumer(consumer_id);
        jserials = KatelloTestScript.toJSONArr(this.servertasks.getSerials(consumer_id));
        Assert.assertEquals((int)jserials.size(), (int)0, (String)"Check: subscriptions should be ==0");
    }
}

