/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tasks;

import com.redhat.qe.katello.base.KatelloApi;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.base.obj.KatelloEnvironment;
import com.redhat.qe.katello.base.obj.KatelloProduct;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.tools.ExecCommands;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class KatelloTasks {
    protected static Logger log = Logger.getLogger(KatelloTasks.class.getName());

    public String apiKatello_POST(String content, String call) throws IOException {
        return this.apiKatello_POST(content, call, null);
    }

    public String apiKatello_POST(String content, String call, String query) throws IOException {
        return KatelloApi.postJson(content, call, query).getContent();
    }

    public String apiKatello_POST_manifest(String manifest, String call) throws IOException {
        return KatelloApi.postFile(manifest, call).getContent();
    }

    public String apiKatello_PUT(String content, String call) throws IOException {
        return KatelloApi.putJson(content, call).getContent();
    }

    public String apiKatello_DELETE(String call) throws IOException {
        return KatelloApi.delete(call).getContent();
    }

    public JSONObject getEnvironment(String orgName, String envName) {
        JSONObject _return = null;
        try {
            log.info(String.format("Retrieve environment: [%s] of Org: [%s]", envName, orgName));
            KatelloEnvironment _env = new KatelloEnvironment(null, null, orgName, null);
            JSONArray envs = KatelloTestScript.toJSONArr(_env.api_list());
            for (int i = 0; i < envs.size(); ++i) {
                JSONObject env = (JSONObject)envs.get(i);
                if (!((String)env.get((Object)"name")).equals(envName)) continue;
                return env;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String deleteEnvironment(String orgName, String envName) {
        String _return = null;
        try {
            String env_id = ((Long)this.getEnvironment(orgName, envName).get((Object)"id")).toString();
            _return = this.apiKatello_DELETE(String.format("/organizations/%s/environments/%s", orgName, env_id));
            log.info(String.format("Deleted the environment [%s] of org: [%s]", envName, orgName));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public JSONObject getEnvFromOrgList(String orgName, String envName) {
        String str_envs = new KatelloEnvironment(null, null, orgName, null).api_list();
        JSONArray json_envs = KatelloTestScript.toJSONArr(str_envs);
        for (int i = 0; i < json_envs.size(); ++i) {
            JSONObject json_env = (JSONObject)json_envs.get(i);
            if (!json_env.get((Object)"name").equals(envName)) continue;
            return json_env;
        }
        return null;
    }

    public String createProvider(String org_name, String provider_name, String descr, String type) {
        String _return = null;
        Object[] json_args = new Object[]{org_name, provider_name, descr, type};
        String mCall = String.format("{'organization_id':'%s', 'provider':{'name':'%s', 'description':'%s', 'provider_type': '%s'}}", json_args);
        try {
            _return = this.apiKatello_POST(mCall, "/providers");
            log.info(String.format("Created a provider with: name=[%s]; description=[%s]; provider_type=[%s]", provider_name, descr, type));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String createProvider(String org_name, String provider_name, String descr, String type, String url) {
        String _return = null;
        Object[] json_args = new Object[]{org_name, provider_name, descr, type, url};
        String mCall = String.format("{'organization_id':'%s', 'provider':{'name':'%s', 'description':'%s', 'provider_type': '%s', 'repository_url':'%s'}}", json_args);
        try {
            _return = this.apiKatello_POST(mCall, "/providers");
            log.info(String.format("Created a provider with: name=[%s]; description=[%s]; provider_type=[%s], repository_url=[%s]", provider_name, descr, type, url));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String createProduct(String org_name, String provider_name, String product_name, String product_descr, String product_url) {
        String _return = null;
        Object[] json_args = new Object[]{product_name, product_descr, product_url};
        String mCall = String.format("{'product':{'name':'%s', 'description':'%s', 'url':'%s'}}", json_args);
        try {
            String provider_id = ((Long)this.getProvider(org_name, provider_name).get((Object)"id")).toString();
            _return = this.apiKatello_POST(mCall, "/providers/" + provider_id + "/product_create");
            log.info(String.format("Created a product for provider: [%s] with: name=[%s]; description=[%s]; url=[%s]", provider_name, product_name, product_descr, product_url));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String createRepository(String providerName, String candlepin_id, String repo_name, String repo_url) {
        String _return = null;
        Object[] json_args = new Object[]{repo_name, candlepin_id, repo_url};
        String mCall = String.format("{'name':'%s', 'product_id':'%s', 'url':'%s'}", json_args);
        try {
            _return = this.apiKatello_POST(mCall, "/repositories");
            log.info(String.format("Created a repo for provider: [%s] with: name=[%s]; product_id=[%s]; url=[%s]", providerName, repo_name, candlepin_id, repo_url));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String import_products(String provider_id, String products_json) {
        String _return = null;
        try {
            _return = this.apiKatello_POST(products_json, "/providers/" + provider_id + "/import_products");
            log.info(String.format("Importing product(s) for provider: id=[%s]", provider_id));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public JSONObject getProductByOrg(String orgName, String productName) {
        JSONObject prod = null;
        try {
            KatelloProduct _prod = new KatelloProduct(null, orgName, null, null, null, null, null, null);
            JSONArray jprods = KatelloTestScript.toJSONArr(_prod.api_list());
            if (jprods == null) {
                return null;
            }
            log.info(String.format("Get product: name=[%s]", productName));
            for (int i = 0; i < jprods.size(); ++i) {
                prod = (JSONObject)jprods.get(i);
                if (!((String)prod.get((Object)"name")).equals(productName)) continue;
                return prod;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public String subscribeConsumer(String consumerID, String poolID) {
        String _return = null;
        try {
            _return = this.apiKatello_POST("", "/consumers/" + consumerID + "/entitlements", "pool=" + poolID);
            log.info(String.format("Subscribing consumer: [%s] to the pool: [%s]", consumerID, poolID));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public JSONObject getProvider(String org_name, String byName) {
        JSONArray providers = KatelloTestScript.toJSONArr(new KatelloProvider(null, org_name, null, null).api_list(org_name));
        for (int i = 0; i < providers.size(); ++i) {
            JSONObject tmpProv = (JSONObject)providers.get(i);
            if (!tmpProv.get((Object)"name").equals(byName)) continue;
            return tmpProv;
        }
        return null;
    }

    public String deleteProvider(String orgName, String providerName) {
        String _return = null;
        String provider_id = ((Long)this.getProvider(orgName, providerName).get((Object)"id")).toString();
        try {
            _return = this.apiKatello_DELETE("/providers/" + provider_id);
            log.info("Delete provider: name=[" + providerName + "]; id=[" + provider_id + "]");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String createConsumer(String orgName, String hostname, String uuid, String json_filename) {
        String _return = null;
        try {
            String sFacts = "{}";
            try {
                BufferedReader br = new BufferedReader(new FileReader(json_filename));
                sFacts = br.readLine();
                br.close();
            }
            catch (IOException iex) {
                log.severe(iex.getMessage());
                throw new RuntimeException(iex);
            }
            sFacts = sFacts.replaceAll("\\$\\{HOSTNAME\\}", hostname);
            sFacts = sFacts.replaceAll("\\$\\{UUID\\}", uuid);
            sFacts = sFacts.replaceAll("\\$\\{ORG_NAME\\}", orgName);
            _return = this.apiKatello_POST(sFacts, "/consumers", "owner=" + orgName);
            log.info(String.format("Creating consumer from [%s] template with: uuid=[%s]; hostname=[%s]; org_name=[%s]", json_filename, uuid, hostname, orgName));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String deleteConsumer(String consumer_id) {
        String _return = null;
        try {
            _return = this.apiKatello_DELETE("/consumers/" + consumer_id);
            log.info(String.format("Remove consumer: uuid=[%s]", consumer_id));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String unsubscribeConsumer(String consumer_id, String serial) {
        String _return = null;
        try {
            _return = this.apiKatello_DELETE("/consumers/" + consumer_id + "/certificates/" + serial);
            log.info(String.format("Unsubscribe consumer: uuid=[%s] from the product with: serial=[%s]", consumer_id, serial));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public String unsubscribeConsumer(String consumer_id) {
        String _return = null;
        try {
            _return = this.apiKatello_DELETE("/consumers/" + consumer_id + "/entitlements");
            log.info(String.format("Unsubscribe consumer: uuid=[%s] from all entitlements", consumer_id));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run_local(boolean showLogResults, String command) {
        String out = null;
        String tmp_cmdFile = "/tmp/katello-" + KatelloTestScript.getUniqueID() + ".sh";
        ExecCommands localRunner = new ExecCommands();
        try {
            localRunner.submitCommandToLocalWithReturn(false, "rm -f " + tmp_cmdFile, "");
            FileOutputStream fout = new FileOutputStream(tmp_cmdFile);
            fout.write((command + "\n").getBytes());
            fout.flush();
            fout.close();
            log.finest(String.format("Executing local: [%s]", command));
            out = localRunner.submitCommandToLocalWithReturn(false, "sh " + tmp_cmdFile, "");
            if (showLogResults) {
                String[] split = out.split("\\n");
                for (int i = 0; i < split.length; ++i) {
                    log.info("Output: " + split[i]);
                }
            }
        }
        catch (IOException iex) {
            log.log(Level.SEVERE, iex.getMessage(), iex);
        }
        finally {
            try {
                localRunner.submitCommandToLocalWithReturn(false, "rm -f " + tmp_cmdFile, "");
            }
            catch (IOException ie) {
                log.log(Level.SEVERE, ie.getMessage(), ie);
            }
        }
        return out;
    }

    public long getDiskFreeForPulpRepos() {
        long dfPulpRepos = Long.MAX_VALUE;
        String res = KatelloUtils.sshOnServer("df `grep \"Alias /pulp/repos\" /etc/httpd/conf.d/pulp.conf | awk '{print $3}'` | tail -1 | awk '{print $3}'").getStdout().trim();
        log.fine("Free disk space for Pulp repositories: [" + res + "]");
        dfPulpRepos = new Long(res);
        return dfPulpRepos;
    }

    public void waitfor_katello() {
        KatelloUtils.sshOnServer("python -c \"from katello.utils import waitfor_katello; waitfor_katello()\"");
    }

    public static String grepCLIOutput(String property, String output) {
        return KatelloTasks.grepCLIOutput(property, output, 1);
    }

    public static String grepCLIOutput(String property, String output, int occurence) {
        int meet_cnt = 0;
        String[] lines = output.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith(property) || ++meet_cnt != occurence) continue;
            String[] split = lines[i].split(":\\s+");
            if (split.length < 2) {
                return lines[i + 1].trim();
            }
            return split[1].trim();
        }
        log.severe("ERROR: Output can not be extracted for the property: [" + property + "]");
        return null;
    }
}

