/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.tasks;

import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.tools.ExecCommands;
import com.redhat.qe.tools.SSHCommandResult;
import com.redhat.qe.tools.SSHCommandRunner;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KatelloCliTasks
implements KatelloConstants {
    protected static Logger log = Logger.getLogger(KatelloCliTasks.class.getName());
    private SSHCommandRunner sshCommandRunner = null;

    public KatelloCliTasks(SSHCommandRunner sshRunner, ExecCommands localRunner) {
        this.setSSHCommandRunner(sshRunner);
    }

    public void setSSHCommandRunner(SSHCommandRunner runner) {
        this.sshCommandRunner = runner;
    }

    public SSHCommandResult execute_remote(String command) {
        try {
            SSHCommandResult cmd_res = this.sshCommandRunner.runCommandAndWait(command);
            return cmd_res;
        }
        catch (Throwable t) {
            log.finest(String.format("Error running the command: [%s]", command));
            return null;
        }
    }

    public SSHCommandResult run_cliCmd(String katelloCliCommand) {
        try {
            return this.sshCommandRunner.runCommandAndWait("katello -uadmin -padmin " + katelloCliCommand);
        }
        catch (Throwable t) {
            log.finest(String.format("Error running the command: [katello %s]", katelloCliCommand));
            return null;
        }
    }

    public void run_cliCmd_nowait(String katelloCliCommand) {
        try {
            this.sshCommandRunner.runCommand("katello -uadmin -padmin " + katelloCliCommand + "&");
        }
        catch (Throwable t) {
            log.finest(String.format("Error running the command: [katello %s]", katelloCliCommand));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String run_local(boolean showLogResults, String command) {
        String out = null;
        String tmp_cmdFile = "/tmp/katello-" + KatelloTestScript.getUniqueID() + ".sh";
        ExecCommands localRunner = new ExecCommands();
        try {
            localRunner.submitCommandToLocalWithReturn(false, "rm -f " + tmp_cmdFile, "");
            FileOutputStream fout = new FileOutputStream(tmp_cmdFile);
            fout.write((command + "\n").getBytes());
            fout.flush();
            fout.close();
            log.finest(String.format("Executing local: [%s]", command));
            out = localRunner.submitCommandToLocalWithReturn(false, "sh " + tmp_cmdFile, "");
            if (showLogResults) {
                String[] split = out.split("\\n");
                for (int i = 0; i < split.length; ++i) {
                    log.info("Output: " + split[i]);
                }
            }
        }
        catch (IOException iex) {
            log.log(Level.SEVERE, iex.getMessage(), iex);
        }
        finally {
            try {
                localRunner.submitCommandToLocalWithReturn(false, "rm -f " + tmp_cmdFile, "");
            }
            catch (IOException ie) {
                log.log(Level.SEVERE, ie.getMessage(), ie);
            }
        }
        return out;
    }

    public static String grepCLIOutput(String property, String output) {
        return KatelloCliTasks.grepCLIOutput(property, output, 1);
    }

    public static String grepCLIOutput(String property, String output, int occurence) {
        int meet_cnt = 0;
        String[] lines = output.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith(property) || ++meet_cnt != occurence) continue;
            String[] split = lines[i].split(":\\s+");
            if (split.length < 2) {
                return lines[i + 1].trim();
            }
            return split[1].trim();
        }
        log.severe("ERROR: Output can not be extracted for the property: [" + property + "]");
        return null;
    }
}

