/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.common;

import java.util.logging.Logger;

public class KatelloInfo {
    protected static Logger log = Logger.getLogger(KatelloInfo.class.getName());
    private String usernameUI = null;
    private String passwordUI = null;
    private String servername = System.getProperty("katello.server.hostname", "localhost");
    private String port = System.getProperty("katello.server.port", "3000");
    private String usernameSSH = null;
    private String passwordSSH = null;
    private String sshKeyPrivate = null;
    private String sshKeyPassphrase = null;
    private static KatelloInfo katelloInst = null;

    private KatelloInfo() {
        this.usernameUI = System.getProperty("katello.ui.user", "admin");
        this.passwordUI = System.getProperty("katello.ui.passphrase", "admin");
        this.usernameSSH = System.getProperty("katello.ssh.user", "root");
        this.passwordSSH = System.getProperty("katello.ssh.passphrase", "redhat");
        this.sshKeyPrivate = System.getProperty("katello.sshkey.private", "~/.ssh/id_dsa.pub");
        this.sshKeyPassphrase = System.getProperty("katello.sshkey.passphrase", "dog8code");
        this.logSettings();
    }

    public static KatelloInfo getInstance() {
        if (katelloInst == null) {
            katelloInst = new KatelloInfo();
        }
        return katelloInst;
    }

    public String getUsernameUI() {
        return this.usernameUI;
    }

    public String getPasswordUI() {
        return this.passwordUI;
    }

    public String getServername() {
        return this.servername;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsernameSSH() {
        return this.usernameSSH;
    }

    public String getPasswordSSH() {
        return this.passwordSSH;
    }

    public String getSshKeyPrivate() {
        return this.sshKeyPrivate;
    }

    public String getSshKeyPassphrase() {
        return this.sshKeyPassphrase;
    }

    private void logSettings() {
        String prop = "katello.server.hostname";
        String value = this.servername;
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
        prop = "katello.server.port";
        value = this.port;
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
        prop = "katello.ui.user";
        value = this.usernameUI;
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
        prop = "katello.ui.passphrase";
        value = "********";
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
        prop = "katello.ssh.user";
        value = this.usernameSSH;
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
        prop = "katello.ssh.passphrase";
        value = "********";
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
        prop = "katello.sshkey.private";
        value = this.sshKeyPrivate;
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
        prop = "katello.sshkey.passphrase";
        value = "********";
        log.fine(String.format("Katello settings: [%s] = [%s]", prop, value));
    }
}

