/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.Assert;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.obj.KatelloGpgKey;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import javax.management.Attribute;

public class KatelloRepo {
    public static final String RH_REPO_PRODUCT_VER = "6Server";
    public static final String RH_REPO_RHEL6_SERVER_RPMS_64BIT = "Red Hat Enterprise Linux 6 Server RPMs x86_64 6Server";
    public static final String CMD_CREATE = "repo create";
    public static final String CMD_SYNCHRONIZE = "repo synchronize";
    public static final String CMD_UPDATE = "repo update";
    public static final String CMD_DELETE = "repo delete";
    public static final String CMD_INFO = "repo info";
    public static final String CMD_ENABLE = "repo enable";
    public static final String CMD_DISABLE = "repo disable";
    public static final String CMD_DISCOVER = "repo discover";
    public static final String CMD_ADD_FILTER = "repo add_filter";
    public static final String CMD_REMOVE_FILTER = "repo remove_filter";
    public static final String CMD_FILTER_LIST = "repo list_filters";
    public static final String CMD_STATUS = "repo status";
    public static final String CMD_LIST = "repo list -v";
    public static final String OUT_CREATE = "Successfully created repository [ %s ]";
    public static final String OUT_DISCOVER = "Successfully created repository [ %s ]";
    public static final String ERR_REPO_NOTFOUND = "Could not find repository [ %s ] within organization [ %s ], product [ %s ] and environment [ %s ]";
    public static final String ERR_REPO_EXISTS = "There is already a repo with the name [ %s ] for product [ %s ]";
    public static final String OUT_FILTER_ADDED = "Added filter [ %s ] to repository [ %s ]";
    public static final String OUT_REPO_SYNCHED = "Repo [ %s ] synced";
    public static final String REG_REPO_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Url:\\s+%s.*Last Sync:\\s+%s.*Progress:\\s+%s.*GPG key:\\s*+%s.*";
    public static final String REG_REPO_STATUS = ".*Package Count:\\s+\\d+.*Last Sync:\\s+%s.*Sync State:\\s+%s.*";
    public static final String REG_FILTER_LIST = ".*\\s+%s.*\\s+%s";
    public static final String REG_REPO_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Package Count:\\s+\\d+.*Last Sync:\\s+%s.*";
    public static final String REG_REPO_LASTSYNC = "\\d{4}/\\d{2}/\\d{2}\\s\\d{2}:\\d{2}:\\d{2}";
    public String name;
    public String org;
    public String product;
    public String url;
    public String gpgkey;
    public String progress;
    public String lastSync;
    public boolean nogpgkey = false;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloRepo(String pName, String pOrg, String pProd, String pUrl, String pGpgkey, Boolean pNogpgkey) {
        this.name = pName;
        this.org = pOrg;
        this.product = pProd;
        this.url = pUrl;
        this.gpgkey = pGpgkey;
        if (pNogpgkey != null) {
            this.nogpgkey = pNogpgkey;
        }
        this.opts = new ArrayList();
    }

    public SSHCommandResult create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.opts.add(new Attribute("url", this.url));
        this.opts.add(new Attribute("gpgkey", this.gpgkey));
        if (this.nogpgkey) {
            this.opts.add(new Attribute("nogpgkey", ""));
        }
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list_filters() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_FILTER_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult synchronize() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_SYNCHRONIZE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult update_gpgkey() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.opts.add(new Attribute("gpgkey", this.gpgkey));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult info(String environment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.opts.add(new Attribute("environment", environment));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult enable() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_ENABLE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult disable() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_DISABLE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult add_filter(String filter) {
        this.opts.clear();
        this.opts.add(new Attribute("filter", filter));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_ADD_FILTER, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult remove_filter(String filter) {
        this.opts.clear();
        this.opts.add(new Attribute("filter", filter));
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_REMOVE_FILTER, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult status() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_STATUS, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult status(String environment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.opts.add(new Attribute("environment", environment));
        this.cli = new KatelloCli(CMD_STATUS, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult discover() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("product", this.product));
        this.opts.add(new Attribute("url", this.url));
        this.opts.add(new Attribute("assumeyes", "y"));
        this.cli = new KatelloCli(CMD_DISCOVER, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("product", this.product));
        this.cli = new KatelloCli(CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult list(String environment) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("environment", environment));
        this.cli = new KatelloCli(CMD_LIST, this.opts);
        return this.cli.run();
    }

    public void assert_repoHasGpg() {
        SSHCommandResult res = this.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo info)");
        String gpg_key = KatelloTasks.grepCLIOutput("GPG key", res.getStdout());
        Assert.assertTrue((boolean)this.gpgkey.equals(gpg_key), (String)String.format("Check - GPG key [%s] should be found in the repo info", this.gpgkey));
        KatelloGpgKey gpg = new KatelloGpgKey(this.gpgkey, this.org, null);
        res = gpg.cli_info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (gpg_key info)");
        String reposWithGpg = KatelloTasks.grepCLIOutput("Repositories", res.getStdout());
        Assert.assertTrue((boolean)reposWithGpg.contains(this.name), (String)"Check - Repo should be in repositories list of GPG key");
    }
}

