/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.obj;

import com.redhat.qe.katello.base.KatelloApi;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.KatelloPostParam;
import com.redhat.qe.katello.base.KatelloTestScript;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.management.Attribute;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class KatelloEnvironment {
    protected static Logger log = Logger.getLogger(KatelloEnvironment.class.getName());
    public static final String LIBRARY = "Library";
    public static final String CMD_CREATE = "environment create";
    public static final String CMD_INFO = "environment info -v";
    public static final String CLI_CMD_LIST = "environment list -v";
    public static final String CMD_DELETE = "environment delete";
    public static final String CMD_UPDATE = "environment update";
    public static final String OUT_CREATE = "Successfully created environment [ %s ]";
    public static final String OUT_DELETE = "Successfully deleted environment [ %s ]";
    public static final String ERROR_INFO = "Could not find environment [ %s ] within organization [ %s ]";
    public static final String OUT_UPDATE = "Successfully updated environment [ %s ]";
    public static final String API_CMD_LIST = "/organizations/%s/environments";
    public static final String API_CMD_CREATE = "/organizations/%s/environments";
    String name;
    String description;
    String org;
    String prior;
    private String prior_id = null;
    private KatelloCli cli;
    private ArrayList<Attribute> opts;

    public KatelloEnvironment(String pName, String pDesc, String pOrg, String pPrior) {
        this.name = pName;
        this.description = pDesc;
        this.org = pOrg;
        this.prior = pPrior;
        this.opts = new ArrayList();
    }

    public SSHCommandResult cli_create() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", this.description));
        this.opts.add(new Attribute("prior", this.prior));
        this.cli = new KatelloCli(CMD_CREATE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_info() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_INFO, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_list() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.cli = new KatelloCli(CLI_CMD_LIST, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_delete() {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.cli = new KatelloCli(CMD_DELETE, this.opts);
        return this.cli.run();
    }

    public SSHCommandResult cli_update(String descr) {
        this.opts.clear();
        this.opts.add(new Attribute("org", this.org));
        this.opts.add(new Attribute("name", this.name));
        this.opts.add(new Attribute("description", descr));
        this.opts.add(new Attribute("prior", this.prior));
        this.cli = new KatelloCli(CMD_UPDATE, this.opts);
        return this.cli.run();
    }

    public String api_list() {
        return KatelloApi.get(String.format("/organizations/%s/environments", this.org)).getContent();
    }

    public String api_create() {
        ArrayList<NameValuePair> opts = new ArrayList<NameValuePair>();
        opts.add((NameValuePair)new BasicNameValuePair("name", this.name));
        opts.add((NameValuePair)new BasicNameValuePair("description", this.description));
        opts.add((NameValuePair)new BasicNameValuePair("prior", this.get_prior_id()));
        KatelloPostParam[] params = new KatelloPostParam[]{new KatelloPostParam("environment", opts)};
        return KatelloApi.post(params, String.format("/organizations/%s/environments", this.org)).getContent();
    }

    public String get_prior_id() {
        if (this.prior_id == null) {
            this.store_id();
        }
        return this.prior_id;
    }

    private void store_id() {
        if (this.prior_id == null) {
            String str_envs = this.api_list();
            JSONArray json_envs = KatelloTestScript.toJSONArr(str_envs);
            for (int i = 0; i < json_envs.size(); ++i) {
                JSONObject json_env = (JSONObject)json_envs.get(i);
                if (!json_env.get((Object)"name").equals(this.prior)) continue;
                this.prior_id = ((Long)json_env.get((Object)"id")).toString();
                break;
            }
        }
        if (this.prior_id == null) {
            log.warning("Unable to retrieve environment.id for: [" + this.name + "]");
        }
    }
}

