/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.cli;

import com.redhat.qe.katello.tasks.KatelloCliTasks;
import com.redhat.qe.tools.SSHCommandResult;

public class KatelloSystem {
    public static final String RHSM_DEFAULT_USER = "admin";
    public static final String RHSM_DEFAULT_PASS = "admin";
    public static final String CMD_INFO = "system info";
    public static final String CMD_LIST = "system list";
    public static final String CMD_SUBSCRIPTIONS = "system subscriptions";
    public static final String CMD_PACKAGES = "system packages";
    public static final String RHSM_CREATE = String.format("subscription-manager register --username %s --password %s", "admin", "admin");
    public static final String OUT_CREATE = "The system has been registered with id:";
    public static final String ERR_RHSM_LOCKER_ONLY = "Organization %s has '%s' environment only. Please create an environment for system registration.";
    public static final String ERR_RHSM_REG_ALREADY_FORCE_NEEDED = "This system is already registered. Use --force to override";
    public static final String ERR_RHSM_REG_MULTI_ENV = "Organization %s has more than one environment. Please specify target environment for system registration.";
    public static final String OUT_REMOTE_ACTION_DONE = "Remote action finished:";
    String name;
    String org;
    String environment;
    private KatelloCliTasks cli;

    public KatelloSystem(KatelloCliTasks pCli, String pName, String pOrg, String pEnv) {
        this.cli = pCli;
        this.name = pName;
        this.org = pOrg;
        this.environment = pEnv;
    }

    public SSHCommandResult rhsm_register() {
        String cmd = RHSM_CREATE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.execute_remote(cmd);
    }

    public SSHCommandResult rhsm_registerForce() {
        String cmd = RHSM_CREATE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        cmd = cmd + " --force";
        return this.cli.execute_remote(cmd);
    }

    public SSHCommandResult list() {
        String cmd = CMD_LIST;
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        cmd = cmd + " -v";
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult subscriptions_available() {
        String cmd = "system subscriptions --available";
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        cmd = cmd + " -v";
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult packages_install(String packageName) {
        String cmd = "system packages --install";
        if (packageName != null) {
            cmd = cmd + " \"" + packageName + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }
}

