/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.cli;

import com.redhat.qe.auto.testng.Assert;
import com.redhat.qe.katello.base.cli.KatelloGpgKey;
import com.redhat.qe.katello.tasks.KatelloCliTasks;
import com.redhat.qe.tools.SSHCommandResult;

public class KatelloRepo {
    public static final String RH_REPO_PRODUCT_VER = "6Server";
    public static final String RH_REPO_RHEL6_SERVER_RPMS_64BIT = "Red Hat Enterprise Linux 6 Server RPMs x86_64 6Server";
    public static final String CMD_CREATE = "repo create";
    public static final String CMD_SYNCHRONIZE = "repo synchronize";
    public static final String CMD_UPDATE = "repo update";
    public static final String CMD_INFO = "repo info";
    public static final String CMD_ENABLE = "repo enable";
    public static final String CMD_ADD_FILTER = "repo add_filter";
    public static final String OUT_CREATE = "Successfully created repository [ %s ]";
    String name;
    String org;
    String product;
    String url;
    String gpgkey;
    boolean nogpgkey = false;
    private KatelloCliTasks cli;

    public KatelloRepo(KatelloCliTasks pCli, String pName, String pOrg, String pProd, String pUrl, String pGpgkey, Boolean pNogpgkey) {
        this.cli = pCli;
        this.name = pName;
        this.org = pOrg;
        this.product = pProd;
        this.url = pUrl;
        this.gpgkey = pGpgkey;
        if (pNogpgkey != null) {
            this.nogpgkey = pNogpgkey;
        }
    }

    public SSHCommandResult create() {
        String cmd = CMD_CREATE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.product != null) {
            cmd = cmd + " --product \"" + this.product + "\"";
        }
        if (this.url != null) {
            cmd = cmd + " --url \"" + this.url + "\"";
        }
        if (this.gpgkey != null) {
            cmd = cmd + " --gpgkey \"" + this.gpgkey + "\"";
        }
        if (this.nogpgkey) {
            cmd = cmd + " --nogpgkey";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult synchronize() {
        String cmd = CMD_SYNCHRONIZE;
        cmd = cmd + String.format(" --name \"%s\" --org \"%s\" --product \"%s\"", this.name, this.org, this.product);
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult update_gpgkey() {
        String cmd = CMD_UPDATE;
        if (this.gpgkey != null) {
            cmd = cmd + " --gpgkey \"" + this.gpgkey + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.product != null) {
            cmd = cmd + " --product \"" + this.product + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult info() {
        String cmd = CMD_INFO;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.product != null) {
            cmd = cmd + " --product \"" + this.product + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult info(String environment) {
        String cmd = CMD_INFO;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.product != null) {
            cmd = cmd + " --product \"" + this.product + "\"";
        }
        if (environment != null) {
            cmd = cmd + " --environment \"" + environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult enable() {
        String cmd = CMD_ENABLE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.product != null) {
            cmd = cmd + " --product \"" + this.product + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult add_filter(String filter) {
        String cmd = CMD_ADD_FILTER;
        if (filter != null) {
            cmd = cmd + " --filter \"" + filter + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.product != null) {
            cmd = cmd + " --product \"" + this.product + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public void assert_repoHasGpg() {
        SSHCommandResult res = this.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (repo info)");
        String gpg_key = KatelloCliTasks.grepCLIOutput("GPG key", res.getStdout());
        Assert.assertTrue((boolean)this.gpgkey.equals(gpg_key), (String)String.format("Check - GPG key [%s] should be found in the repo info", this.gpgkey));
        KatelloGpgKey gpg = new KatelloGpgKey(this.cli, this.gpgkey, this.org, null);
        res = gpg.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (gpg_key info)");
        String reposWithGpg = KatelloCliTasks.grepCLIOutput("Repositories", res.getStdout());
        Assert.assertTrue((boolean)reposWithGpg.contains(this.name), (String)"Check - Repo should be in repositories list of GPG key");
    }
}

