/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.cli;

import com.redhat.qe.katello.tasks.KatelloCliTasks;
import com.redhat.qe.tools.SSHCommandResult;

public class KatelloOrg {
    public static final String DEFAULT_ORG = "ACME_Corporation";
    public static final String CMD_CREATE = "org create";
    public static final String CMD_INFO = "org info";
    public static final String CMD_LIST = "org list";
    public static final String CMD_SUBSCRIPTIONS = "org subscriptions";
    public static final String CMD_UEBERCERT = "org uebercert";
    public static final String CMD_DELETE = "org delete";
    public static final String ERR_TEMPLATE_NOTFOUND = "Could not find template [ %s ]";
    public static final String OUT_CREATE = "Successfully created org [ %s ]";
    String name;
    String description;
    private KatelloCliTasks cli;

    public KatelloOrg(KatelloCliTasks pCli, String pName, String pDesc) {
        this.cli = pCli;
        this.name = pName;
        this.description = pDesc;
    }

    public SSHCommandResult create() {
        String cmd = CMD_CREATE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.description != null) {
            cmd = cmd + " --description \"" + this.description + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult info() {
        String cmd = CMD_INFO;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult list() {
        String cmd = CMD_LIST;
        cmd = cmd + " -v";
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult subscriptions() {
        String cmd = CMD_SUBSCRIPTIONS;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult uebercert() {
        String cmd = CMD_UEBERCERT;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult delete() {
        String cmd = CMD_DELETE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }
}

