/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.cli;

import com.redhat.qe.katello.tasks.KatelloCliTasks;
import com.redhat.qe.tools.SSHCommandResult;

public class KatelloChangeset {
    public static final String CMD_CREATE = "changeset create";
    public static final String CMD_PROMOTE = "changeset promote";
    public static final String CMD_UPDATE = "changeset update";
    public static final String CMD_INFO = "changeset info";
    public static final String OUT_CREATE = "Successfully created changeset [ %s ]";
    String name;
    String org;
    String environment;
    private KatelloCliTasks cli;

    public KatelloChangeset(KatelloCliTasks pCli, String pName, String pOrg, String pEnv) {
        this.cli = pCli;
        this.name = pName;
        this.org = pOrg;
        this.environment = pEnv;
    }

    public SSHCommandResult create() {
        String cmd = CMD_CREATE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult promote() {
        String cmd = CMD_PROMOTE;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult info() {
        String cmd = CMD_INFO;
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult update_addProduct(String productName) {
        String cmd = "changeset update --add_product";
        if (productName != null) {
            cmd = cmd + " \"" + productName + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult update_fromProduct_addRepo(String productName, String repoName) {
        String cmd = "changeset update --from_product";
        if (productName != null) {
            cmd = cmd + " \"" + productName + "\"";
        }
        if (repoName != null) {
            cmd = cmd + " --add_repo \"" + repoName + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult update_fromProduct_addErrata(String productName, String errataName) {
        String cmd = CMD_UPDATE;
        if (productName != null) {
            cmd = cmd + " --from_product \"" + productName + "\"";
        }
        if (errataName != null) {
            cmd = cmd + " --add_erratum \"" + errataName + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult update_addTemplate(String templatename) {
        String cmd = CMD_UPDATE;
        if (templatename != null) {
            cmd = cmd + " --add_template \"" + templatename + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }
}

