/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base.cli;

import com.redhat.qe.auto.testng.Assert;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.cli.KatelloEnvironment;
import com.redhat.qe.katello.base.cli.KatelloTemplate;
import com.redhat.qe.katello.tasks.KatelloCliTasks;
import com.redhat.qe.tools.SSHCommandResult;

public class KatelloActivationKey {
    String org;
    String environment;
    String name;
    String description;
    String template;
    private KatelloCliTasks cli;
    private String id;
    private String environment_id;
    private String template_id;
    public static final String CMD_CREATE = "activation_key create";
    public static final String CMD_INFO = "activation_key info";
    public static final String CMD_LIST = "activation_key list";
    public static final String ERR_TEMPLATE_NOTFOUND = "Could not find template [ %s ]";
    public static final String OUT_CREATE = "Successfully created activation key [ %s ]";

    public KatelloActivationKey(KatelloCliTasks pCli, String pOrg, String pEnv, String pName, String pDesc, String pTemplate) {
        this.cli = pCli;
        this.org = pOrg;
        this.environment = pEnv;
        this.name = pName;
        this.description = pDesc;
        this.template = pTemplate;
    }

    public SSHCommandResult create() {
        String cmd = CMD_CREATE;
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.environment != null) {
            cmd = cmd + " --environment \"" + this.environment + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        if (this.description != null) {
            cmd = cmd + " --description \"" + this.description + "\"";
        }
        if (this.template != null) {
            cmd = cmd + " --template \"" + this.template + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult info() {
        String cmd = CMD_INFO;
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        if (this.name != null) {
            cmd = cmd + " --name \"" + this.name + "\"";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult list() {
        String cmd = CMD_LIST;
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\" -v";
        }
        return this.cli.run_cliCmd(cmd);
    }

    public SSHCommandResult list(String pEnvironment) {
        String cmd = CMD_LIST;
        if (this.org != null) {
            cmd = cmd + " --org \"" + this.org + "\"";
        }
        cmd = cmd + " --environment \"" + pEnvironment + "\" -v";
        return this.cli.run_cliCmd(cmd);
    }

    public void asserts_create() {
        SSHCommandResult res;
        if (this.id == null) {
            this.updateIDs();
        }
        Assert.assertTrue(((res = this.list(this.environment)).getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key list)");
        String REGEXP_AK_LIST = ".*Id:\\s+\\d+.*Name:\\s+%s.*Environment Id:\\s+%s.*System Template Id:\\s+%s.*";
        String match_info = String.format(REGEXP_AK_LIST, this.name, this.environment_id, this.template_id).replaceAll("\"", "");
        if (this.template_id == null) {
            match_info = String.format(REGEXP_AK_LIST, this.name, this.environment_id, "None").replaceAll("\"", "");
        }
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Activation key [%s] should be found in the list", this.name));
        res = this.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (activation_key info)");
        String REGEXP_AK_INFO = ".*Id:\\s+\\d+.*Name:\\s+%s.*Environment Id:\\s+%s.*System Template Id:\\s+%s.*Pools:.*";
        match_info = String.format(REGEXP_AK_INFO, this.name, this.environment_id, this.template_id).replaceAll("\"", "");
        if (this.template_id == null) {
            match_info = String.format(REGEXP_AK_INFO, this.name, this.environment_id, "None").replaceAll("\"", "");
        }
        Assert.assertTrue((boolean)KatelloCliTestScript.sgetOutput(res).replaceAll("\n", "").matches(match_info), (String)String.format("Activation key [%s] should contain correct info", this.name));
    }

    private void updateIDs() {
        SSHCommandResult res;
        if (this.environment != null) {
            KatelloEnvironment env = new KatelloEnvironment(this.cli, this.environment, null, this.org, "Library");
            res = env.info();
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (environment info)");
            this.environment_id = KatelloCliTasks.grepCLIOutput("Id", res.getStdout());
        }
        if (this.template != null) {
            KatelloTemplate tmpl = new KatelloTemplate(this.cli, this.template, null, this.org, null);
            res = tmpl.info(this.environment);
            Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code (template info)");
            this.template_id = KatelloCliTasks.grepCLIOutput("Id", res.getStdout());
        }
        if (this.name != null) {
            res = this.info();
            this.id = KatelloCliTasks.grepCLIOutput("Id", res.getStdout());
        }
    }
}

