/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base;

import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.katello.base.KatelloCliTestScript;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class KatelloTestScript
extends TestScript
implements KatelloConstants {
    protected static Logger log = Logger.getLogger(KatelloTestScript.class.getName());
    protected KatelloTasks servertasks = new KatelloTasks();
    private SimpleDateFormat dateFormatter = null;
    public static String default_org = null;

    public KatelloTestScript() {
        try {
            this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            if (default_org == null) {
                this.setup_defaultOrg();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Date parseKatelloDate(String strDate) throws java.text.ParseException {
        String sDate = strDate.substring(0, 19);
        return this.dateFormatter.parse(sDate);
    }

    public static String getUniqueID() {
        try {
            Thread.sleep(1000 + Math.abs(new Random().nextInt(200)));
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        String uid = String.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L);
        log.fine(String.format("Generating unique ID: [%s]", uid));
        return uid;
    }

    public static String getUUID() {
        return KatelloTasks.run_local(false, "python -c \"import uuid; print uuid.uuid1();\"");
    }

    public static JSONObject toJSONObj(String str_json) {
        JSONObject _return = null;
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(str_json);
            _return = (JSONObject)obj;
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    public static JSONArray toJSONArr(String str_json) {
        JSONArray _return = null;
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(str_json);
            _return = (JSONArray)obj;
        }
        catch (ParseException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return _return;
    }

    protected String getOutput(SSHCommandResult res) {
        return KatelloCliTestScript.sgetOutput(res);
    }

    private void setup_defaultOrg() {
        KatelloOrg _org = new KatelloOrg(null, null);
        String res = _org.api_list();
        JSONArray orgs = KatelloTestScript.toJSONArr(res);
        for (int i = 0; i < orgs.size(); ++i) {
            JSONObject org = (JSONObject)orgs.get(i);
            if (((Long)org.get((Object)"id")).intValue() != 1) continue;
            default_org = (String)org.get((Object)"name");
            return;
        }
    }
}

