/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base;

import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.katello.base.KatelloCli;
import com.redhat.qe.katello.base.obj.KatelloOrg;
import com.redhat.qe.katello.base.obj.KatelloProvider;
import com.redhat.qe.katello.base.obj.KatelloRepo;
import com.redhat.qe.katello.common.KatelloConstants;
import com.redhat.qe.katello.common.KatelloUtils;
import com.redhat.qe.katello.tasks.KatelloTasks;
import com.redhat.qe.tools.SSHCommandResult;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Logger;
import org.testng.Assert;

public class KatelloCliTestScript
extends TestScript
implements KatelloConstants {
    protected static Logger log = Logger.getLogger(KatelloCliTestScript.class.getName());
    private int platform_id = -1;

    public int getClientPlatformID() {
        return this.platform_id;
    }

    protected void assert_providerRemoved(KatelloProvider prov) {
        log.info("Assertions: provider has been removed");
        SSHCommandResult res = prov.info();
        Assert.assertTrue((res.getExitCode() == 65 ? 1 : 0) != 0, (String)"Check - return code");
        Assert.assertEquals((String)this.getOutput(res).trim(), (String)("Could not find provider [ " + prov.name + " ] " + "within organization [ " + prov.org + " ]"), (String)"Check - `provider info` return string");
    }

    protected void assert_repoSynced(KatelloRepo repo) {
        log.info("Assertions: repository has been synchronized");
        SSHCommandResult res = repo.info();
        Assert.assertTrue((res.getExitCode() == 0 ? 1 : 0) != 0, (String)"Check - return code");
        String REGEXP_REPO_INFO = ".*Name:\\s+" + repo.name + ".*Package Count:\\s+0.*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REPO_INFO), (String)"Repo should not contain packages count: 0");
        REGEXP_REPO_INFO = ".*Name:\\s+" + repo.name + ".*Last Sync:\\s+never.*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REPO_INFO), (String)"Repo should not contain last_sync == never");
        REGEXP_REPO_INFO = ".*Name:\\s+" + repo.name + ".*Progress:\\s+Not synced.*";
        Assert.assertFalse((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REPO_INFO), (String)"Repo should not contain progress == not synced");
        String cnt = KatelloTasks.grepCLIOutput("Package Count", res.getStdout());
        Assert.assertTrue((new Integer(cnt) > 0 ? 1 : 0) != 0, (String)"Repo should contain packages count: >0");
        REGEXP_REPO_INFO = ".*Name:\\s+" + repo.name + ".*Progress:\\s+Finished.*";
        Assert.assertTrue((boolean)this.getOutput(res).replaceAll("\n", "").matches(REGEXP_REPO_INFO), (String)"Repo should contain progress == finished");
    }

    protected void waitfor_reposync(KatelloRepo repo, int timeoutMinutes) {
        long now;
        long start = now = Calendar.getInstance().getTimeInMillis() / 1000L;
        long maxWaitSec = start + (long)(timeoutMinutes * 60);
        String REGEXP_STATUS_FINISHED = ".*Sync State:\\s+Finished.*";
        log.fine("Waiting repo sync finish for: minutes=[" + timeoutMinutes + "]; " + "org=[" + repo.org + "]; product=[" + repo.product + "]; repo=[" + repo.name + "]");
        while (now < maxWaitSec) {
            SSHCommandResult res = repo.status();
            now = Calendar.getInstance().getTimeInMillis() / 1000L;
            if (this.getOutput(res).replaceAll("\n", "").matches(REGEXP_STATUS_FINISHED)) break;
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {}
        }
        if (now <= maxWaitSec) {
            log.fine("Repo sync done in: [" + String.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L - start) + "] sec");
        } else {
            log.warning("Repo sync did not finished after: [" + String.valueOf(maxWaitSec - start) + "] sec");
        }
    }

    protected void waitfor_orgsubscriptions(KatelloOrg org, int timeoutMinutes) {
        long now;
        long start = now = Calendar.getInstance().getTimeInMillis() / 1000L;
        long maxWaitSec = start + (long)(timeoutMinutes * 60);
        String REGEXP_SUBSCR = ".*Subscription:\\s+.*";
        log.fine("Waiting org subscriptions available for: minutes=[" + timeoutMinutes + "]; " + "org=[" + org.name + "]");
        while (now < maxWaitSec) {
            SSHCommandResult res = org.subscriptions();
            now = Calendar.getInstance().getTimeInMillis() / 1000L;
            if (this.getOutput(res).replaceAll("\n", "").matches(REGEXP_SUBSCR)) break;
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {}
        }
        if (now <= maxWaitSec) {
            log.fine("Org subscriptions done in: [" + String.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L - start) + "] sec");
        } else {
            log.warning("Org subscriptions did not finished after: [" + String.valueOf(maxWaitSec - start) + "] sec");
        }
    }

    protected void waitfor_reposync(KatelloRepo repo, String lastsynced, int timeoutMinutes) {
        long now;
        long start = now = Calendar.getInstance().getTimeInMillis() / 1000L;
        long maxWaitSec = start + (long)(timeoutMinutes * 60);
        log.fine("Waiting repo sync finish for: minutes=[" + timeoutMinutes + "]; " + "org=[" + repo.org + "]; product=[" + repo.product + "]; repo=[" + repo.name + "]");
        while (now < maxWaitSec) {
            SSHCommandResult res = repo.info();
            now = Calendar.getInstance().getTimeInMillis() / 1000L;
            String newsync = KatelloTasks.grepCLIOutput("Last Sync", this.getOutput(res).trim(), 1);
            if (!lastsynced.equals(newsync)) break;
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {}
        }
        if (now <= maxWaitSec) {
            log.fine("Repo sync done in: [" + String.valueOf(Calendar.getInstance().getTimeInMillis() / 1000L - start) + "] sec");
        } else {
            log.warning("Repo sync did not finished after: [" + String.valueOf(maxWaitSec - start) + "] sec");
        }
    }

    protected ArrayList<String> getOrgsWithImportedManifest() {
        String[] lines;
        ArrayList<String> orgs = new ArrayList<String>();
        String servername = System.getProperty("katello.server.hostname", "localhost");
        log.info("Scanning [" + servername + "] for organizations with imported manifest");
        KatelloCli cli = new KatelloCli("org list -v | grep \"^Name\" | cut -d: -f2", null);
        SSHCommandResult res = cli.run();
        for (String org : lines = this.getOutput(res).split("\n")) {
            org = org.trim();
            res = new KatelloCli("product list --provider=\"Red Hat\" --org \"" + org + "\" -v | grep \"^Id:\\s\\+69\" | wc -l", null).run();
            if (!this.getOutput(res).equals("1")) continue;
            orgs.add(org);
        }
        return orgs;
    }

    protected boolean hasOrg_environment(String org, String environment) {
        log.info(String.format("Check if the org [%s] has an environment [%s]", org, environment));
        SSHCommandResult res = new KatelloCli("environment list\" --org \"" + org + "\" -v | grep \"^Name:\\s\\+" + environment + "\" | wc -l", null).run();
        return this.getOutput(res).equals("1");
    }

    protected SSHCommandResult rhsm_clean() {
        log.info("RHSM clean");
        return KatelloUtils.sshOnClient("subscription-manager clean");
    }

    protected SSHCommandResult rhsm_register(String org, String environment, String name, boolean autosubscribe) {
        log.info("Registering client with: --org \"" + org + "\" --environment \"" + environment + "\" " + "--name \"" + name + "\" --autosubscribe " + Boolean.toString(autosubscribe));
        String cmd = String.format("subscription-manager register --username admin --password admin --org \"%s\" --environment \"%s\" --name \"%s\"", org, environment, name);
        if (autosubscribe) {
            cmd = cmd + " --autosubscribe";
        }
        return KatelloUtils.sshOnClient(cmd);
    }

    protected String getOutput(SSHCommandResult res) {
        return KatelloCliTestScript.sgetOutput(res);
    }

    public static String sgetOutput(SSHCommandResult res) {
        return (res.getStdout() + "\n" + res.getStderr()).trim();
    }
}

