/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.katello.base;

import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.katello.base.KatelloApiResponse;
import com.redhat.qe.katello.base.KatelloPostParam;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;

public class KatelloApi {
    private static Executor executor;
    protected static Logger log;

    private static URI buildURI(String apiCall, String apiQuery) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("https").setHost(System.getProperty("katello.server.hostname", "localhost")).setPath("/" + System.getProperty("katello.product", "katello") + "/api" + apiCall).setQuery(apiQuery);
        return builder.build();
    }

    private static KatelloApiResponse _doRequest(Request request) {
        KatelloApiResponse response = null;
        try {
            HttpResponse returnResponse = executor.execute(request.connectTimeout(1000).socketTimeout(1000)).returnResponse();
            HttpEntity entity = returnResponse.getEntity();
            BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            reader.close();
            response = new KatelloApiResponse(buffer.toString(), returnResponse.getStatusLine().getStatusCode(), returnResponse.getStatusLine().getReasonPhrase());
        }
        catch (IOException ex) {
            response = new KatelloApiResponse(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        return response;
    }

    public static KatelloApiResponse get(String call) {
        return KatelloApi.get(call, null);
    }

    public static KatelloApiResponse get(String call, String query) {
        try {
            URI uri = KatelloApi.buildURI(call, query);
            return KatelloApi._doRequest(Request.Get((URI)uri));
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static KatelloApiResponse _post(HttpEntity postEntity, String call, String query) {
        try {
            URI uri = KatelloApi.buildURI(call, query);
            return KatelloApi._doRequest(Request.Post((URI)uri).body(postEntity));
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static KatelloApiResponse _put(HttpEntity putEntity, String call, String query) {
        try {
            URI uri = KatelloApi.buildURI(call, query);
            return KatelloApi._doRequest(Request.Put((URI)uri).body(putEntity));
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static KatelloApiResponse _delete(String call) {
        try {
            URI uri = KatelloApi.buildURI(call, "");
            return KatelloApi._doRequest(Request.Delete((URI)uri));
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static KatelloApiResponse postJson(String content, String call, String query) {
        return KatelloApi.post(content, call, query, ContentType.APPLICATION_JSON);
    }

    public static KatelloApiResponse post(String content, String call, String query, ContentType contentType) {
        StringEntity postEntity = new StringEntity(content, contentType);
        return KatelloApi._post((HttpEntity)postEntity, call, query);
    }

    public static KatelloApiResponse post(List<NameValuePair> nvp, String call) {
        return KatelloApi.post(nvp, call, null);
    }

    public static KatelloApiResponse post(List<NameValuePair> nvp, String call, String query) {
        StringEntity postEntity = new StringEntity(URLEncodedUtils.format(nvp, (String)"UTF-8"), ContentType.APPLICATION_FORM_URLENCODED);
        log.info(URLEncodedUtils.format(nvp, (String)"UTF-8"));
        return KatelloApi._post((HttpEntity)postEntity, call, query);
    }

    public static KatelloApiResponse post(KatelloPostParam[] params, String call) {
        return KatelloApi.post(params, call, null);
    }

    public static KatelloApiResponse post(KatelloPostParam[] params, String call, String query) {
        String content = "";
        for (KatelloPostParam param : params) {
            content = String.format("%s%s,", content, param);
        }
        if (content.length() > 1) {
            content = content.substring(0, content.length() - 1);
        }
        content = String.format("{%s}", content);
        StringEntity postEntity = new StringEntity(content, ContentType.APPLICATION_JSON);
        return KatelloApi._post((HttpEntity)postEntity, call, query);
    }

    public static KatelloApiResponse postFile(String manifest, String call) {
        FileEntity postEntity = new FileEntity(new File(manifest));
        return KatelloApi._post((HttpEntity)postEntity, call, null);
    }

    public static KatelloApiResponse putJson(String content, String call) {
        return KatelloApi.putJson(content, call, null);
    }

    public static KatelloApiResponse putJson(String content, String call, String query) {
        StringEntity putEntity = new StringEntity(content, ContentType.APPLICATION_JSON);
        return KatelloApi._put((HttpEntity)putEntity, call, query);
    }

    public static KatelloApiResponse delete(String call) {
        return KatelloApi._delete(call);
    }

    static {
        log = Logger.getLogger(KatelloApi.class.getName());
        new TestScript();
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            }}, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
            Executor.registerScheme((Scheme)httpsScheme);
        }
        catch (Exception e) {
            System.err.println("HttpClient: Scheme not initialized properly");
            e.printStackTrace();
        }
        executor = Executor.newInstance().auth(new HttpHost(System.getProperty("katello.server.hostname", "localhost"), 443, "https"), System.getProperty("katello.admin.username", "admin"), System.getProperty("katello.admin.password", "admin")).authPreemptive(new HttpHost(System.getProperty("katello.server.hostname", "localhost"), 443, "https"));
    }
}

