/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.tools;

import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    private static DefaultHttpClient httpclient = new DefaultHttpClient();
    private static Logger log = Logger.getLogger(HttpClient.class.getName());
    private static OAuthConsumer consumer = null;

    public static void setOAuthCredentials(String key, String secret) {
        log.info("Setting client oath key to " + key);
        log.info("Setting client oath secret to " + secret);
        consumer = new CommonsHttpOAuthConsumer(key, secret);
    }

    public static String[] getRequest(String protocol, String server, String port, String path, String username, String password, String sContentType, String sAcceptHeader, NameValuePair[] nvpList) throws Exception {
        HttpGet get = new HttpGet(HttpClient.buildUrl(protocol, server, port, path));
        return HttpClient.finishRequest((HttpUriRequest)get, username, password, null, sContentType, sAcceptHeader, nvpList);
    }

    public static String[] postRequest(String protocol, String server, String port, String path, String username, String password, String requestBody, String sContentType, String sAcceptHeader, NameValuePair[] nvpList) throws Exception {
        HttpPost post = new HttpPost(HttpClient.buildUrl(protocol, server, port, path));
        return HttpClient.finishRequest((HttpUriRequest)post, username, password, requestBody, sContentType, sAcceptHeader, nvpList);
    }

    public static String[] putRequest(String protocol, String server, String port, String path, String username, String password, String requestBody, String sContentType, String sAcceptHeader, NameValuePair[] nvpList) throws Exception {
        HttpPut put = new HttpPut(HttpClient.buildUrl(protocol, server, port, path));
        return HttpClient.finishRequest((HttpUriRequest)put, username, password, requestBody, sContentType, sAcceptHeader, nvpList);
    }

    public static String[] deleteRequest(String protocol, String server, String port, String path, String username, String password, String requestBody, String sContentType, String sAcceptHeader) throws Exception {
        HttpDeleteWithBody delete = new HttpDeleteWithBody(HttpClient.buildUrl(protocol, server, port, path));
        return HttpClient.finishRequest((HttpUriRequest)delete, username, password, requestBody, sContentType, sAcceptHeader, null);
    }

    private static String[] finishRequest(HttpUriRequest method, String username, String password, String requestBody, String sContentType, String sAcceptHeader, NameValuePair[] nvpList) throws Exception {
        String sArgs = "";
        if (requestBody != null) {
            if (requestBody.contains("&") && !requestBody.contains("&&")) {
                String[] items;
                for (String i : items = requestBody.split("&")) {
                    sArgs = sArgs + " -d " + i;
                }
            } else {
                sArgs = sArgs + " -d '" + requestBody + "'";
            }
        }
        if (nvpList != null) {
            for (NameValuePair key : nvpList) {
                key.getName();
                key.getValue();
                sArgs = sArgs + " -d " + key.getName() + "='" + key.getValue() + "'";
                requestBody = requestBody == null ? key.getName() + "=" + key.getValue() + "" : requestBody + "&" + key.getName() + "=" + key.getValue() + "";
            }
        }
        if (sContentType != null) {
            sArgs = sArgs + " -H \"Content-Type: " + sContentType + "\"";
        }
        method.addHeader("Content-Type", sContentType);
        if (sAcceptHeader != null) {
            sArgs = sArgs + " -H \"Accept: " + sAcceptHeader + "\"";
            method.addHeader("Accept", sAcceptHeader);
        }
        if (requestBody != null) {
            StringEntity entity = new StringEntity(requestBody, "UTF-8");
            BasicHeader basicHeader = new BasicHeader("Content-Type", sContentType);
            entity.setContentType((Header)basicHeader);
            if (method instanceof HttpPut) {
                ((HttpPut)method).setEntity((HttpEntity)entity);
            } else if (method instanceof HttpPost) {
                ((HttpPost)method).setEntity((HttpEntity)entity);
            } else if (method instanceof HttpDeleteWithBody) {
                ((HttpDeleteWithBody)method).setEntity((HttpEntity)entity);
            }
        }
        if (method.getURI().getScheme().equalsIgnoreCase("https")) {
            sArgs = sArgs + " --insecure";
            HttpClient.setupHTTPS(method);
        }
        if (consumer != null) {
            consumer.sign((Object)method);
        } else if (username != null && password != null) {
            sArgs = sArgs + " -u " + username + ":" + password;
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            method.addHeader(new BasicScheme().authenticate((Credentials)creds, (HttpRequest)method));
            HttpClient.setCredentials(method.getURI().getHost(), method.getURI().getPort(), username, password);
        }
        log.info("cmdline curl equivalent: curl -X " + method.getMethod().toString() + sArgs + " " + method.getURI());
        return HttpClient.processRequest(method, username, password);
    }

    private static void setCredentials(String fqdn, int port, String username, String password) {
        if (!username.equals("")) {
            httpclient.getCredentialsProvider().setCredentials(new AuthScope(fqdn, port), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    private static void setupHTTPS(HttpUriRequest method) throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager easyTrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        X509HostnameVerifier verifier = new X509HostnameVerifier(){

            public void verify(String string, SSLSocket ssls) throws IOException {
            }

            public void verify(String string, X509Certificate xc) throws SSLException {
            }

            public void verify(String string, String[] strings, String[] strings1) throws SSLException {
            }

            public boolean verify(String string, SSLSession ssls) {
                return true;
            }
        };
        SSLContext sslcontext = SSLContext.getInstance("SSL");
        sslcontext.init(null, new TrustManager[]{easyTrustManager}, null);
        SSLSocketFactory socketFactory = new SSLSocketFactory(sslcontext);
        socketFactory.setHostnameVerifier(verifier);
        Scheme sch = new Scheme("https", method.getURI().getPort() == -1 ? 443 : method.getURI().getPort(), (SchemeSocketFactory)socketFactory);
        httpclient.getConnectionManager().getSchemeRegistry().register(sch);
    }

    private static String[] processRequest(HttpUriRequest method, String username, String password) throws Exception {
        String[] response = new String[2];
        String server = method.getURI().getHost();
        HttpResponse httpResponse = httpclient.execute(method);
        response[0] = Integer.toString(httpResponse.getStatusLine().getStatusCode());
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            response[1] = EntityUtils.toString((HttpEntity)entity);
        }
        return response;
    }

    private static String buildUrl(String protocol, String server, String port, String path) {
        return port == null ? protocol + "://" + server + path : protocol + "://" + server + ":" + port + path;
    }

    @NotThreadSafe
    private static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }

        public HttpDeleteWithBody() {
        }
    }
}

