/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.auto.bugzilla;

import com.redhat.qe.auto.bugzilla.BlockedByBzBug;
import com.redhat.qe.auto.bugzilla.BzBugDependency;
import com.redhat.qe.auto.bugzilla.BzChecker;
import com.redhat.qe.auto.testng.TestScript;
import com.redhat.qe.jul.AbstractTestProcedureHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlrpc.XmlRpcException;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.internal.IResultListener;

public class BugzillaTestNGListener
implements IResultListener,
ISuiteListener {
    private static final String AUTO_VERIFIED = "AutoVerified";
    private static final String BLOCKED_BY_BUG = "blockedByBug";
    private static final String VERIFIES_BUG = "verifiesBug";
    protected static Logger log = Logger.getLogger(BugzillaTestNGListener.class.getName());
    protected static BzChecker bzChecker = null;
    protected static Map<Object[], BzBugDependency> bzTests = new HashMap<Object[], BzBugDependency>();
    protected static HashSet<String> blockingBugs = new HashSet();

    public void onConfigurationFailure(ITestResult arg0) {
    }

    public void onConfigurationSkip(ITestResult arg0) {
    }

    public void onConfigurationSuccess(ITestResult arg0) {
    }

    public void onFinish(ITestContext arg0) {
    }

    public void onStart(ITestContext arg0) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onTestFailure(ITestResult arg0) {
    }

    public void onTestSkipped(ITestResult arg0) {
    }

    protected BzBugDependency getBzData(Object[] params) {
        for (Object param : params) {
            if (!(param instanceof BzBugDependency)) continue;
            return (BzBugDependency)param;
        }
        return null;
    }

    public void onTestStart(ITestResult result) {
        if (result.getStatus() == 3) {
            return;
        }
        try {
            bzChecker = BzChecker.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String[] groups = result.getMethod().getGroups();
        Pattern p = Pattern.compile("[verifiesBug|blockedByBug]-(\\d+)");
        for (String group : groups) {
            Matcher m = p.matcher(group);
            if (!m.find()) continue;
            String number = m.group(1);
            this.lookupBugAndSkipIfOpen(number);
        }
        Object[] params = result.getParameters();
        BzBugDependency bbb = this.getBzData(params);
        if (bbb != null) {
            String[] bugIds;
            for (String bugId : bugIds = bbb.getBugIds()) {
                this.lookupBugAndSkipIfOpen(bugId);
            }
        }
    }

    protected void lookupBugAndSkipIfOpen(String bugId) {
        boolean isBugOpen;
        String summary;
        BzChecker.bzState state;
        try {
            state = bzChecker.getBugState(bugId);
            summary = bzChecker.getBugField(bugId, "summary").toString();
            isBugOpen = bzChecker.isBugOpen(bugId);
        }
        catch (XmlRpcException xre) {
            log.log(Level.WARNING, "Could not determine the state of Bugzilla bug " + bugId + ". Assuming test needs to be run.", xre);
            return;
        }
        if (isBugOpen) {
            blockingBugs.add(bugId);
            throw new SkipException("This test is blocked by " + state.toString() + " Bugzilla bug '" + summary + "'.  (https://bugzilla.redhat.com/show_bug.cgi?id=" + bugId + ")");
        }
        log.log(Level.INFO, "This test was previously blocked by " + state.toString() + " Bugzilla bug '" + summary + "'.  (https://bugzilla.redhat.com/show_bug.cgi?id=" + bugId + ")");
    }

    public void onTestSuccess(ITestResult result) {
        BzBugDependency blockedOrVerifiedBy;
        try {
            bzChecker = BzChecker.getInstance();
        }
        catch (Exception e) {
            return;
        }
        String[] groups = result.getMethod().getGroups();
        Pattern p = Pattern.compile("[verifiesBug|blockedByBug]-(\\d+)");
        for (String group : groups) {
            BzChecker.bzState state;
            Matcher m = p.matcher(group);
            if (!m.find()) continue;
            String number = m.group(1);
            try {
                state = bzChecker.getBugState(number);
            }
            catch (XmlRpcException xre) {
                log.log(Level.WARNING, "Could not determine the state of bug " + number + ". It may need to be closed if is hasn't been already.", xre);
                break;
            }
            if (group.startsWith(VERIFIES_BUG)) {
                log.fine("This test verifies bugzilla bug #" + number);
                if (state.equals((Object)BzChecker.bzState.ON_QA)) {
                    log.warning("Need to verify bug " + number + "!");
                    this.verifyComment(result, number);
                    continue;
                }
                log.warning("Bug " + number + " has been verified, but it is in " + state + " state instead of ON_QA");
                continue;
            }
            log.warning("Test is now unblocked by bug " + number + ".");
        }
        if ((blockedOrVerifiedBy = bzTests.get(result.getParameters())) != null) {
            log.warning("Bugs that were previously blocking this test: " + Arrays.deepToString(blockedOrVerifiedBy.getBugIds()) + ".");
            if (blockedOrVerifiedBy.getType().equals((Object)BzBugDependency.Type.Verifies)) {
                this.verifyComment(result, blockedOrVerifiedBy.getBugIds());
            }
        }
    }

    public void onFinish(ISuite arg0) {
        if (blockingBugs.size() > 0) {
            Iterator<String> it = blockingBugs.iterator();
            StringBuffer sb = new StringBuffer("https://bugzilla.redhat.com/buglist.cgi?bug_id=");
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            log.log(Level.INFO, String.format("There were %d bugs blocking tests in this run: %s", blockingBugs.size(), sb.toString()));
        }
    }

    public void onStart(ISuite arg0) {
    }

    protected void verifyComment(ITestResult result, String ... bugNumbers) {
        for (String bugNumber : bugNumbers) {
            try {
                if (bzChecker.getBugField(bugNumber, "keywords").toString().indexOf(AUTO_VERIFIED) != -1) {
                    log.info("Bug " + bugNumber + " already has the AutoVerified keyword.");
                    return;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not determine if bug " + bugNumber + " has been marked AutoVerified yet.", e);
            }
            StringBuffer sb = new StringBuffer();
            bzChecker.login(System.getProperty("bugzilla.login"), System.getProperty("bugzilla.password"));
            sb.append("Verified by Automated Test " + result.getName() + " parameters: (" + Arrays.deepToString(result.getParameters()) + ")\n");
            String log = AbstractTestProcedureHandler.getActiveLog();
            if (log != null) {
                sb.append("Automation log:\n");
            }
            sb.append(AbstractTestProcedureHandler.getActiveLog());
            bzChecker.addKeywords(bugNumber, new String[]{AUTO_VERIFIED});
            bzChecker.addComment(bugNumber, sb.toString());
        }
        bzTests.remove(result.getParameters());
    }

    public static void main(String ... args) {
        Pattern p = Pattern.compile("[verifiesBug|blockedByBug]-(\\d+)");
        Matcher m = p.matcher("blockedByBug-12354542");
        m.find();
        System.out.println(m.group(1));
    }

    @Test(groups={"test"}, dataProvider="mydp")
    public void mytest(Object meta, String arg) {
        System.out.println("passed " + arg);
    }

    @DataProvider(name="mydp")
    public Object[][] dp1() {
        return new Object[][]{{null, "what's up"}, {new BlockedByBzBug("683914"), "hi there"}};
    }

    static {
        TestScript testScript = new TestScript();
    }
}

