/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerMultiTransactionMain;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.curator.framework.api.transaction.CuratorMultiTransaction;
import org.apache.curator.framework.api.transaction.CuratorMultiTransactionMain;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.CuratorMultiTransactionRecord;
import org.apache.curator.framework.imps.CuratorTransactionImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.framework.schema.Schema;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;

public class CuratorMultiTransactionImpl
implements CuratorMultiTransaction,
CuratorMultiTransactionMain,
BackgroundOperation<CuratorMultiTransactionRecord>,
ErrorListenerMultiTransactionMain {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding = new Backgrounding();

    public CuratorMultiTransactionImpl(CuratorFrameworkImpl client) {
        this.client = client;
    }

    public CuratorMultiTransactionImpl(CuratorFrameworkImpl client, Backgrounding backgrounding) {
        this.client = client;
        this.backgrounding = backgrounding;
    }

    @Override
    public ErrorListenerMultiTransactionMain inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerMultiTransactionMain inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerMultiTransactionMain inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerMultiTransactionMain inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerMultiTransactionMain inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(callback, executor);
        return this;
    }

    @Override
    public ErrorListenerMultiTransactionMain inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public CuratorMultiTransactionMain withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public List<CuratorTransactionResult> forOperations(CuratorOp ... operations) throws Exception {
        ArrayList<CuratorOp> ops = operations != null ? Arrays.asList(operations) : Lists.newArrayList();
        return this.forOperations(ops);
    }

    @Override
    public List<CuratorTransactionResult> forOperations(List<CuratorOp> operations) throws Exception {
        Preconditions.checkArgument(!(operations = Preconditions.checkNotNull(operations, "operations cannot be null")).isEmpty(), "operations list cannot be empty");
        CuratorMultiTransactionRecord record = new CuratorMultiTransactionRecord();
        for (CuratorOp curatorOp : operations) {
            Schema schema = this.client.getSchemaSet().getSchema(curatorOp.getTypeAndPath().getForPath());
            record.add(curatorOp.get(), curatorOp.getTypeAndPath().getType(), curatorOp.getTypeAndPath().getForPath());
            if (curatorOp.get().getType() == 1 || curatorOp.get().getType() == 19) {
                CreateMode createMode;
                CreateRequest createRequest = (CreateRequest)curatorOp.get().toRequestRecord();
                if (this.client.isZk34CompatibilityMode()) {
                    try {
                        createMode = CreateMode.fromFlag(createRequest.getFlags());
                    }
                    catch (KeeperException.BadArgumentsException dummy) {
                        createMode = CreateMode.PERSISTENT;
                    }
                } else {
                    createMode = CreateMode.fromFlag((int)createRequest.getFlags(), (CreateMode)CreateMode.PERSISTENT);
                }
                schema.validateCreate(createMode, createRequest.getPath(), createRequest.getData(), createRequest.getAcl());
                continue;
            }
            if (curatorOp.get().getType() == 2 || curatorOp.get().getType() == 20) {
                DeleteRequest deleteRequest = (DeleteRequest)curatorOp.get().toRequestRecord();
                schema.validateDelete(deleteRequest.getPath());
                continue;
            }
            if (curatorOp.get().getType() != 5) continue;
            SetDataRequest setDataRequest = (SetDataRequest)curatorOp.get().toRequestRecord();
            schema.validateGeneral(setDataRequest.getPath(), setDataRequest.getData(), null);
        }
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<CuratorMultiTransactionRecord>(this, record, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), null), null);
            return null;
        }
        return this.forOperationsInForeground(record);
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<CuratorMultiTransactionRecord> operationAndData) throws Exception {
        try {
            final TimeTrace trace = this.client.getZookeeperClient().startTracer("CuratorMultiTransactionImpl-Background");
            AsyncCallback.MultiCallback callback = new AsyncCallback.MultiCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    trace.commit();
                    List<CuratorTransactionResult> curatorResults = opResults != null ? CuratorTransactionImpl.wrapResults(CuratorMultiTransactionImpl.this.client, opResults, (CuratorMultiTransactionRecord)operationAndData.getData()) : null;
                    CuratorEventImpl event = new CuratorEventImpl(CuratorMultiTransactionImpl.this.client, CuratorEventType.TRANSACTION, rc, path, null, ctx, null, null, null, null, null, curatorResults);
                    CuratorMultiTransactionImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            this.client.getZooKeeper().multi(operationAndData.getData(), callback, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    private List<CuratorTransactionResult> forOperationsInForeground(final CuratorMultiTransactionRecord record) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("CuratorMultiTransactionImpl-Foreground");
        List<OpResult> responseData = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return CuratorMultiTransactionImpl.this.client.getZooKeeper().multi(record);
            }
        });
        trace.commit();
        return CuratorTransactionImpl.wrapResults(this.client, responseData, record);
    }
}

