/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.serviceprovider;

import com.flipkart.ranger.healthcheck.HealthChecker;
import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthservice.ServiceHealthAggregator;
import com.flipkart.ranger.model.Serializer;
import com.flipkart.ranger.model.ServiceNode;
import com.github.rholder.retry.BlockStrategies;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProvider<T> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceProvider.class);
    private String serviceName;
    private Serializer<T> serializer;
    private CuratorFramework curatorFramework;
    private ServiceNode<T> serviceNode;
    private List<Healthcheck> healthchecks;
    private final int healthUpdateInterval;
    private final int staleUpdateThreshold;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> future;
    private ServiceHealthAggregator serviceHealthAggregator;

    public ServiceProvider(String serviceName, Serializer<T> serializer, CuratorFramework curatorFramework, ServiceNode<T> serviceNode, List<Healthcheck> healthchecks, int healthUpdateInterval, int staleUpdateThreshold, ServiceHealthAggregator serviceHealthAggregator) {
        this.serviceName = serviceName;
        this.serializer = serializer;
        this.curatorFramework = curatorFramework;
        this.serviceNode = serviceNode;
        this.healthchecks = healthchecks;
        this.healthUpdateInterval = healthUpdateInterval;
        this.staleUpdateThreshold = staleUpdateThreshold;
        this.serviceHealthAggregator = serviceHealthAggregator;
    }

    public void updateState(ServiceNode<T> serviceNode) throws Exception {
        String path = String.format("/%s/%s", this.serviceName, serviceNode.representation());
        if (null == this.curatorFramework.checkExists().forPath(path)) {
            this.createPath();
        }
        this.curatorFramework.setData().forPath(path, this.serializer.serialize(serviceNode));
    }

    public void start() throws Exception {
        this.serviceHealthAggregator.start();
        this.curatorFramework.blockUntilConnected();
        this.curatorFramework.createContainers(String.format("/%s", this.serviceName));
        logger.debug("Connected to zookeeper for {}", (Object)this.serviceName);
        this.createPath();
        logger.debug("Set initial node data on zookeeper for {}", (Object)this.serviceName);
        this.future = this.executorService.scheduleWithFixedDelay(new HealthChecker(this.healthchecks, this), 0L, this.healthUpdateInterval, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Exception {
        this.serviceHealthAggregator.stop();
        if (null != this.future) {
            this.future.cancel(true);
        }
        this.curatorFramework.close();
    }

    public ServiceNode<T> getServiceNode() {
        return this.serviceNode;
    }

    public int getStaleUpdateThreshold() {
        return this.staleUpdateThreshold;
    }

    private void createPath() throws Exception {
        Retryer<Void> retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(KeeperException.NodeExistsException.class).withWaitStrategy(WaitStrategies.fixedWait(1L, TimeUnit.SECONDS)).withBlockStrategy(BlockStrategies.threadSleepStrategy()).withStopStrategy(StopStrategies.neverStop()).build();
        try {
            retryer.call(() -> {
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.EPHEMERAL)).forPath(String.format("/%s/%s", this.serviceName, this.serviceNode.representation()), this.serializer.serialize(this.serviceNode));
                return null;
            });
        }
        catch (Exception e) {
            String message = String.format("Could not create node for %s after 60 retries (1 min). This service will not be discoverable. Retry after some time.", this.serviceName);
            logger.error(message, e);
            throw new Exception(message, e);
        }
    }
}

