/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.finder;

import com.flipkart.ranger.finder.Service;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.model.Deserializer;
import com.flipkart.ranger.model.PathBuilder;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.model.ServiceRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.zookeeper.WatchedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryUpdater<T>
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistryUpdater.class);
    private ServiceRegistry<T> serviceRegistry;
    private final boolean disableWatchers;
    private Lock checkLock = new ReentrantLock();
    private Condition checkCondition = this.checkLock.newCondition();
    private boolean checkForUpdate = false;

    public ServiceRegistryUpdater(ServiceRegistry<T> serviceRegistry, boolean disableWatchers) {
        this.serviceRegistry = serviceRegistry;
        this.disableWatchers = disableWatchers;
    }

    public void start() throws Exception {
        CuratorFramework curatorFramework = this.serviceRegistry.getService().getCuratorFramework();
        if (!this.disableWatchers) {
            ((BackgroundPathable)curatorFramework.getChildren().usingWatcher(new CuratorWatcher(){

                @Override
                public void process(WatchedEvent event) throws Exception {
                    switch (event.getType()) {
                        case NodeChildrenChanged: {
                            ServiceRegistryUpdater.this.checkForUpdate();
                            break;
                        }
                    }
                }
            })).forPath(PathBuilder.path(this.serviceRegistry.getService()));
        }
        this.updateRegistry();
        logger.info("Started polling zookeeper for changes for service:{}", (Object)this.serviceRegistry.getService().getServiceName());
    }

    @Override
    public Void call() throws Exception {
        while (true) {
            try {
                this.checkLock.lock();
                while (!this.checkForUpdate) {
                    this.checkCondition.await();
                }
                this.updateRegistry();
                this.checkForUpdate = false;
                continue;
            }
            finally {
                this.checkLock.unlock();
                continue;
            }
            break;
        }
    }

    public void checkForUpdate() {
        try {
            this.checkLock.lock();
            this.checkForUpdate = true;
            this.checkCondition.signalAll();
        }
        finally {
            this.checkLock.unlock();
        }
    }

    private Optional<List<ServiceNode<T>>> checkForUpdateOnZookeeper() {
        try {
            long healthcheckZombieCheckThresholdTime = System.currentTimeMillis() - 60000L;
            Service service = this.serviceRegistry.getService();
            String serviceName = service.getServiceName();
            if (!service.isRunning()) {
                return Optional.empty();
            }
            Deserializer<T> deserializer = this.serviceRegistry.getDeserializer();
            CuratorFramework curatorFramework = service.getCuratorFramework();
            String parentPath = PathBuilder.path(service);
            logger.debug("Looking for node list of [{}]", (Object)serviceName);
            List children = (List)curatorFramework.getChildren().forPath(parentPath);
            ArrayList<ServiceNode<T>> nodes = Lists.newArrayListWithCapacity(children.size());
            logger.debug("Found {} nodes for [{}]", (Object)children.size(), (Object)serviceName);
            for (String child : children) {
                byte[] data;
                String path = String.format("%s/%s", parentPath, child);
                boolean hasChild = null != curatorFramework.checkExists().forPath(path);
                byte[] byArray = data = hasChild ? (byte[])curatorFramework.getData().forPath(path) : null;
                if (null == data) {
                    logger.warn("Not data present for node: {} of [{}]", (Object)path, (Object)serviceName);
                    continue;
                }
                ServiceNode<T> key = deserializer.deserialize(data);
                if (HealthcheckStatus.healthy != key.getHealthcheckStatus()) continue;
                if (key.getLastUpdatedTimeStamp() > healthcheckZombieCheckThresholdTime) {
                    nodes.add(key);
                    continue;
                }
                logger.warn("Zombie node [{}:{}] found for [{}]", key.getHost(), key.getPort(), serviceName);
            }
            return Optional.of(nodes);
        }
        catch (Exception e) {
            logger.error("Error getting service data from zookeeper: ", e);
            return Optional.empty();
        }
    }

    public void stop() {
        logger.info("Stopped updater for [{}]", (Object)this.serviceRegistry.getService().getServiceName());
    }

    private void updateRegistry() {
        List nodes = this.checkForUpdateOnZookeeper().orElse(null);
        if (null != nodes) {
            logger.debug("Updating nodelist of size: {} for [{}]", (Object)nodes.size(), (Object)this.serviceRegistry.getService().getServiceName());
            this.serviceRegistry.nodes(nodes);
        } else {
            logger.warn("No service shards/nodes found. We are disconnected from zookeeper. Keeping old list for {}", (Object)this.serviceRegistry.getService().getServiceName());
        }
    }
}

