/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.ranger.finder;

import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.model.ServiceNodeSelector;
import com.flipkart.ranger.model.ServiceRegistry;
import com.flipkart.ranger.model.ShardSelector;
import java.util.List;

public class ServiceFinder<T, ServiceRegistryType extends ServiceRegistry<T>> {
    private final ServiceRegistryType serviceRegistry;
    private final ShardSelector<T, ServiceRegistryType> shardSelector;
    private final ServiceNodeSelector<T> nodeSelector;

    public ServiceFinder(ServiceRegistryType serviceRegistry, ShardSelector<T, ServiceRegistryType> shardSelector, ServiceNodeSelector<T> nodeSelector) {
        this.serviceRegistry = serviceRegistry;
        this.shardSelector = shardSelector;
        this.nodeSelector = nodeSelector;
    }

    public ServiceNode<T> get(T criteria) {
        List<ServiceNode<T>> nodes = this.shardSelector.nodes(criteria, this.serviceRegistry);
        if (null == nodes || nodes.isEmpty()) {
            return null;
        }
        return this.nodeSelector.select(nodes);
    }

    public List<ServiceNode<T>> getAll(T criteria) {
        return this.shardSelector.nodes(criteria, this.serviceRegistry);
    }

    public void start() throws Exception {
        ((ServiceRegistry)this.serviceRegistry).start();
    }

    public void stop() throws Exception {
        ((ServiceRegistry)this.serviceRegistry).stop();
    }
}

