/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.authenticator;

import com.google.common.base.Preconditions;
import com.yammer.dropwizard.authenticator.LdapAuthenticator;
import com.yammer.dropwizard.authenticator.LdapUser;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;
import java.util.Collections;
import java.util.Optional;

public class ResourceAuthenticator
implements Authenticator<BasicCredentials, LdapUser> {
    private final LdapAuthenticator ldapAuthenticator;

    public ResourceAuthenticator(LdapAuthenticator ldapAuthenticator) {
        this.ldapAuthenticator = (LdapAuthenticator)Preconditions.checkNotNull((Object)ldapAuthenticator);
    }

    public Optional<LdapUser> authenticate(BasicCredentials credentials) throws AuthenticationException {
        if (this.ldapAuthenticator.authenticate(credentials)) {
            return Optional.of(new LdapUser(credentials.getUsername(), Collections.emptySet()));
        }
        return Optional.empty();
    }
}

