/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.authenticator.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;
import java.security.Principal;

public class LdapHealthCheck<T extends Principal>
extends HealthCheck {
    private final Authenticator<BasicCredentials, T> ldapAuthenticator;

    public LdapHealthCheck(Authenticator<BasicCredentials, T> ldapAuthenticator) {
        this.ldapAuthenticator = (Authenticator)Preconditions.checkNotNull(ldapAuthenticator, (Object)"ldapAuthenticator cannot be null");
    }

    public HealthCheck.Result check() throws AuthenticationException {
        if (this.ldapAuthenticator.authenticate((Object)new BasicCredentials("", "")).isPresent()) {
            return HealthCheck.Result.healthy();
        }
        return HealthCheck.Result.unhealthy((String)"Cannot contact authentication service");
    }
}

