/*
 * Decompiled with CFR 0.152.
 */
package com.ranger.hazelcast.servicediscovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.ranger.hazelcast.servicediscovery.RangerDiscoveryConfiguration;
import io.appform.ranger.client.zk.SimpleRangerZKClient;
import io.appform.ranger.common.server.ShardInfo;
import io.appform.ranger.core.healthcheck.Healthchecks;
import io.appform.ranger.core.model.Serializer;
import io.appform.ranger.core.model.ServiceNode;
import io.appform.ranger.core.serviceprovider.ServiceProvider;
import io.appform.ranger.zookeeper.ServiceProviderBuilders;
import io.appform.ranger.zookeeper.serde.ZkNodeDataSerializer;
import io.appform.ranger.zookeeper.serviceprovider.ZkServiceProviderBuilder;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;

public class RangerDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    public static final String CONFIG_PREFIX = "discovery.ranger";
    private final ObjectMapper objectMapper;
    private final ILogger logger;
    private final CuratorFramework curator;
    private ServiceProvider<ShardInfo, ZkNodeDataSerializer<ShardInfo>> serviceProvider;
    private final SimpleRangerZKClient<ShardInfo> rangerClient;
    private final String serviceName;
    private final int refreshIntervalMs;
    private final int staleUpdateThresholdMs;
    private final boolean isMember;

    public RangerDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        String zkConnectionString = (String)((Object)this.getOrNull(CONFIG_PREFIX, RangerDiscoveryConfiguration.ZK_CONNECTION_STRING));
        String namespace = (String)((Object)this.getOrNull(CONFIG_PREFIX, RangerDiscoveryConfiguration.NAMESPACE));
        this.serviceName = (String)((Object)this.getOrNull(CONFIG_PREFIX, RangerDiscoveryConfiguration.SERVICE_NAME));
        this.refreshIntervalMs = (Integer)this.getOrDefault(CONFIG_PREFIX, RangerDiscoveryConfiguration.HEALTH_UPDATE_INTERVAL_MS, Integer.valueOf(5000));
        this.staleUpdateThresholdMs = (Integer)this.getOrDefault(CONFIG_PREFIX, RangerDiscoveryConfiguration.STALE_UPDATE_THRESHOLD_INTERVAL_MS, Integer.valueOf(16000));
        this.logger = logger;
        this.objectMapper = new ObjectMapper();
        this.isMember = discoveryNode != null;
        this.curator = this.buildCurator(zkConnectionString, namespace);
        if (this.isMember) {
            String host = discoveryNode.getPublicAddress().getHost();
            int port = discoveryNode.getPublicAddress().getPort();
            this.serviceProvider = this.buildServiceProvider(this.objectMapper, namespace, this.serviceName, host, port);
        }
        this.rangerClient = this.buildDiscoveryClient(namespace);
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            if (this.rangerClient != null && this.rangerClient.getAllNodes() != null) {
                return this.rangerClient.getAllNodes().stream().map(n -> {
                    Map<String, String> attributes = Collections.singletonMap("hostname", n.getHost());
                    try {
                        return new SimpleDiscoveryNode(new Address(n.getHost(), n.getPort()), attributes);
                    }
                    catch (UnknownHostException e) {
                        this.logger.severe("Error adding discovered member", (Throwable)e);
                        return null;
                    }
                }).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            this.logger.severe("Error discovering nodes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private CuratorFramework buildCurator(String connectionString, String namespace) {
        return CuratorFrameworkFactory.builder().connectString(connectionString).namespace(namespace).retryPolicy((RetryPolicy)new RetryForever(1000)).build();
    }

    private ServiceProvider<ShardInfo, ZkNodeDataSerializer<ShardInfo>> buildServiceProvider(ObjectMapper objectMapper, String namespace, String serviceName, String hostname, int port) {
        return ((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)((ZkServiceProviderBuilder)ServiceProviderBuilders.unshardedServiceProviderBuilder().withCuratorFramework(this.curator).withNamespace(namespace).withServiceName(serviceName)).withSerializer((Serializer)((ZkNodeDataSerializer)data -> {
            try {
                return objectMapper.writeValueAsBytes((Object)data);
            }
            catch (JsonProcessingException e) {
                this.logger.severe("Error serializing data", (Throwable)e);
                return null;
            }
        }))).withHostname(hostname)).withNodeData((Object)ShardInfo.builder().region(System.getenv("CONFIG_ENV")).tags(Collections.emptySet()).environment(System.getenv("CONFIG_ENV")).build())).withPort(port)).withHealthcheck(Healthchecks.defaultHealthyCheck())).withHealthUpdateIntervalMs(this.refreshIntervalMs)).withStaleUpdateThresholdMs(this.staleUpdateThresholdMs)).build();
    }

    private SimpleRangerZKClient<ShardInfo> buildDiscoveryClient(String namespace) {
        return ((SimpleRangerZKClient.SimpleRangerZKClientBuilder)((SimpleRangerZKClient.SimpleRangerZKClientBuilder)SimpleRangerZKClient.builder().curatorFramework(this.curator).namespace(namespace).mapper(this.objectMapper).serviceName(this.serviceName).disableWatchers(true).nodeRefreshIntervalMs(this.refreshIntervalMs).deserializer(data -> {
            try {
                return (ServiceNode)this.objectMapper.readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (IOException e) {
                this.logger.severe("Error parsing node data with value " + new String(data), (Throwable)e);
                return null;
            }
        }).initialCriteria(shardInfo -> true)).alwaysUseInitialCriteria(false)).build();
    }

    public void start() {
        this.curator.start();
        if (this.isMember) {
            this.serviceProvider.start();
        }
        this.rangerClient.start();
        this.logger.info("Ranger discovery initialized successfully");
    }

    public void destroy() {
        if (this.isMember) {
            this.serviceProvider.stop();
        }
        this.rangerClient.stop();
        this.curator.close();
        this.logger.info("Ranger discovery stopped successfully");
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }
}

