/*
 * Decompiled with CFR 0.152.
 */
package com.ranger.hazelcast.servicediscovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceFinderBuilders;
import com.flipkart.ranger.ServiceProviderBuilders;
import com.flipkart.ranger.finder.unsharded.UnshardedClusterFinder;
import com.flipkart.ranger.finder.unsharded.UnshardedClusterInfo;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.serviceprovider.ServiceProvider;
import com.hazelcast.logging.ILogger;
import java.io.IOException;
import java.util.List;

class RangerServiceDiscoveryHelper {
    private static ServiceProvider<UnshardedClusterInfo> serviceProvider;
    private static UnshardedClusterFinder serviceFinder;
    private static final ObjectMapper objectMapper;

    RangerServiceDiscoveryHelper() {
    }

    static void start(String zkConnectionString, String namespace, String serviceName, String hostname, int port, ILogger logger) throws Exception {
        if (serviceProvider == null && hostname != null) {
            serviceProvider = ServiceProviderBuilders.unshardedServiceProviderBuilder().withConnectionString(zkConnectionString).withNamespace(namespace).withServiceName(serviceName).withSerializer(serviceNode -> {
                try {
                    return objectMapper.writeValueAsBytes((Object)serviceNode);
                }
                catch (JsonProcessingException e) {
                    logger.severe("Cannot serialize data: " + serviceNode.representation(), (Throwable)e);
                    return null;
                }
            }).withHostname(hostname).withPort(port).withHealthcheck(() -> HealthcheckStatus.healthy).buildServiceDiscovery();
            serviceProvider.start();
        }
        if (serviceFinder == null) {
            serviceFinder = (UnshardedClusterFinder)ServiceFinderBuilders.unshardedFinderBuilder().withConnectionString(zkConnectionString).withNamespace(namespace).withServiceName(serviceName).withDeserializer(data -> {
                try {
                    return (ServiceNode)objectMapper.readValue(data, (TypeReference)new TypeReference<ServiceNode<UnshardedClusterInfo>>(){});
                }
                catch (IOException e) {
                    logger.severe("Error staring service discovery!", (Throwable)e);
                    return null;
                }
            }).build();
            serviceFinder.start();
        }
    }

    static List<ServiceNode<UnshardedClusterInfo>> getAllNodes() {
        return serviceFinder.getAll(null);
    }

    static void stop() throws Exception {
        if (serviceProvider != null) {
            serviceProvider.stop();
        }
        if (serviceFinder != null) {
            serviceFinder.stop();
        }
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

