/*
 * Decompiled with CFR 0.152.
 */
package com.ranger.hazelcast.servicediscovery;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.ranger.hazelcast.servicediscovery.RangerDiscoveryConfiguration;
import com.ranger.hazelcast.servicediscovery.RangerServiceDiscoveryHelper;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class RangerDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private String zkConnectionString = (String)((Object)this.getOrNull("discovery.ranger", RangerDiscoveryConfiguration.ZK_CONNECTION_STRING));
    private String namespace = (String)((Object)this.getOrNull("discovery.ranger", RangerDiscoveryConfiguration.NAMESPACE));
    private String serviceName = (String)((Object)this.getOrNull("discovery.ranger", RangerDiscoveryConfiguration.SERVICE_NAME));
    private final DiscoveryNode discoveryNode;
    private ILogger logger;

    public RangerDiscoveryStrategy(DiscoveryNode discoveryNode, final ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.discoveryNode = discoveryNode;
        this.logger = logger;
        try {
            String host = discoveryNode != null ? discoveryNode.getPublicAddress().getHost() : null;
            int port = discoveryNode != null ? discoveryNode.getPublicAddress().getPort() : 0;
            RangerServiceDiscoveryHelper.start(this.zkConnectionString, this.namespace, this.serviceName, host, port, logger);
        }
        catch (Exception e) {
            logger.severe("Failed to start service discovery!", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    RangerServiceDiscoveryHelper.stop();
                }
                catch (Exception e) {
                    logger.severe("Error adding shutdown hook!", (Throwable)e);
                }
            }
        });
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        return RangerServiceDiscoveryHelper.getAllNodes().stream().map(n -> {
            Map<String, String> attributes = Collections.singletonMap("hostname", n.getHost());
            try {
                return new SimpleDiscoveryNode(new Address(n.getHost(), n.getPort()), attributes);
            }
            catch (UnknownHostException e) {
                this.logger.severe("Error adding discovered member", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }
}

