(ns metricsaurus-rex.ring.handlers
  (:require [metricsaurus-rex.metrics.snapshot :as snapshot]
            [metricsaurus-rex.healthchecks :as healthchecks]
            [cheshire.core :as json]
            [cheshire.generate :as generate]))


;;hack to "encode" throwables so I don't break backwards compatability
(generate/add-encoder java.lang.Throwable (fn [c generator]))

(defn metrics-handler [request]
  {:status 200
   :body (snapshot/all-metrics)})

(defn healthcheck-handler [request]
  (let [results (healthchecks/run-health-checks)
        status  (if (healthchecks/healthy? results) 200 500)]
    {:status status :body (json/generate-string results)}))

