(ns metricsaurus-rex.healthchecks
  (:import [com.codahale.metrics.health HealthCheckRegistry HealthCheck HealthCheck$Result]
           [com.codahale.metrics.health.jvm ThreadDeadlockHealthCheck]))

(defn detect-deadlocks [registry]
  (.register registry "Deadlocks" (ThreadDeadlockHealthCheck.)))

(defn create-registry []
  (HealthCheckRegistry.))

(def ^:dynamic *registry*
  (doto (create-registry)
    (detect-deadlocks)))

(defn register [^String name f]
  (.register *registry* name
             (proxy [HealthCheck] []
               (check []
                 (if-let [result (f)]
                   (HealthCheck$Result/unhealthy (str result))
                   (HealthCheck$Result/healthy))))))

(defn run-health-checks []
    (for [[name ^HealthCheck$Result result] (.runHealthChecks *registry*)]
      {:name    name
       :healthy (.isHealthy result)
       :message (.getMessage result)
       :error   (.getError result)}))

(defn healthy? [results]
  (every? :healthy results))
