(use '[clojure.java.shell :only [sh]])
(require '(leiningen deploy))

(defproject com.rallydev/jarvis "0.5.0"
  :description "A robot for FlowDock"
  :url "http://github.com/RallySoftware/jarvis"
  :license {:name "The MIT License (MIT)"
            :url "http://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.5.0"]
                 [com.rallydev/clj-flowdock "1.1.0"]
                 [org.codehaus.groovy/groovy-all "2.1.0"]
                 [org.clojure/java.classpath "0.2.0"]
                 [org.clojure/tools.logging "0.2.6"]
                 [clj-http "0.7.2"]
                 [fs "1.3.2"]
                 [ch.qos.logback/logback-classic "1.0.9"]
                 [compojure "1.1.3"]
                 [netty-ring-adapter "0.2.4"]]
  :source-paths ["src/main/clojure" "src/plugins"]
  :java-source-paths ["src/main/java"]
  :test-paths ["src/test/clojure"]
  :resource-paths ["src/main/resources"]
  :plugins [[lein-clojars "0.9.1"]]
  :jvm-opts ["-Xmx1G" "-DLOG_DIR=./logs"]
  :jar-name "jarvis.jar")
