(ns jarvis.rally.helpers
  (:require [cheshire.core :as json]
            [clojure.string :as s]))

(def rally-base-url "https://rally1.rallydev.com")
(def type-map {"HierarchicalRequirement" "userstory"})

(defn detail-url [artifact-type artifact-oid]
  (str rally-base-url "/#/detail/" artifact-type "/" artifact-oid))

(defn message->formatted-id [message]
  (-> message
    (get "content")
    (s/split #"\s")
    (nth 1)))

(defn artifact-type->user-friendly-type [artifact-type]
  (if-let [type (get type-map artifact-type)]
    type
    (.toLowerCase artifact-type)))
