(ns jarvis.plugins.rally
  (:require [clj-rally.api.artifact :as artifact]
            [jarvis.rally.helpers :as helpers]
            [clojure.string :as s]))

(declare get-info)

(defn ^{:description "<formattedID> - Returns the details"
        :command "rally"
        :author "Jonathan Chauncey Matt Farrar"
        :plugin true}
  rally [message content-vec]
  (let [formatted-id (nth content-vec 1)]
    (if-let [artifact (artifact/get-by-formatted-id formatted-id)]
      (get-info artifact)
      "Dreadfully sorry, I was unable to find an artifact with that Formatted ID.")))

(defn get-info [artifact]
  (let [artifact-map (.artifact artifact)]
    (str
      "\n\t"
      "Formatted ID: " (get artifact-map "FormattedID") "\n\t"
      "Name: " (get artifact-map "Name") "\n\t"
      "Owner: " (get-in artifact-map ["Owner" "_refObjectName"]) "\n\t"
      "Project: " (get-in artifact-map ["Project" "_refObjectName"]) "\n\t"
      "ScheduleState: " (get artifact-map "ScheduleState") "\n\t"
      "Description: " (get artifact-map "Description") "\n\t"
      "Detail Link: " (helpers/detail-url (.artifact-type artifact) (get artifact-map "ObjectID")))))
