(ns jarvis.rally.helpers
  (:require [cheshire.core :as json]
            [clojure.string :as s]))

(def rally-base-url "https://rally1.rallydev.com")

(defn detail-url [artifact-type artifact-oid]
  (str rally-base-url "/#/detail/" artifact-type "/" artifact-oid))

(defn message->formatted-id [message]
  (-> message
    (get "content")
    (s/split #"\s")
    (nth 1)))
